/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core;

import io.tarantool.driver.api.SingleValueCallResult;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.metadata.TarantoolSpaceMetadata;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.mappers.CallResultMapper;
import io.tarantool.driver.mappers.MessagePackMapper;
import io.tarantool.driver.mappers.MessagePackObjectMapper;
import io.tarantool.driver.mappers.MessagePackValueMapper;
import io.tarantool.driver.mappers.converters.ValueConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.stream.Collectors;
import org.msgpack.value.Value;
import org.springframework.data.tarantool.core.BaseTarantoolTemplate;
import org.springframework.data.tarantool.core.convert.TarantoolConverter;
import org.springframework.data.tarantool.core.mapping.TarantoolMappingContext;
import org.springframework.util.Assert;

public class TarantoolTemplate
extends BaseTarantoolTemplate {
    public TarantoolTemplate(TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> tarantoolClient, TarantoolMappingContext mappingContext, TarantoolConverter converter, ForkJoinPool.ForkJoinWorkerThreadFactory queryExecutorsFactory) {
        super(tarantoolClient, mappingContext, converter, queryExecutorsFactory);
    }

    @Override
    public <T> T callForTuple(String functionName, List<?> parameters, String spaceName, Class<T> entityClass) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        List<T> result = this.callForTupleList(functionName, parameters, spaceName, entityClass);
        return result != null && !result.isEmpty() ? (T)result.get(0) : null;
    }

    @Override
    public <T> T callForTuple(String functionName, List<?> parameters, ValueConverter<Value, T> entityConverter) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityConverter, (String)"Entity converter must not be null!");
        List<T> result = this.callForTupleList(functionName, parameters, entityConverter);
        return result != null && !result.isEmpty() ? (T)result.get(0) : null;
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, List<?> parameters, String spaceName, Class<T> entityClass) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return (List)this.executeSync(this.getResultSupplier(functionName, parameters, spaceName, entityClass));
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, List<?> parameters, ValueConverter<Value, T> entityConverter) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityConverter, (String)"Entity converter must not be null!");
        return (List)this.executeSync(this.getCustomResultSupplier(functionName, parameters, (MessagePackObjectMapper)this.getMessagePackMapper(), entityConverter));
    }

    @Override
    public <T> T callForObject(String functionName, List<?> parameters, ValueConverter<Value, T> entityConverter) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityConverter, (String)"Entity converter must not be null!");
        return (T)this.executeSync(() -> this.tarantoolClient.callForSingleResult(functionName, this.mapParameters(parameters), (MessagePackObjectMapper)this.getMessagePackMapper(), entityConverter));
    }

    @Override
    public <T> T callForObject(String functionName, List<?> parameters, Class<T> entityClass) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return (T)this.executeSync(() -> this.tarantoolClient.callForSingleResult(functionName, this.mapParameters(parameters), entityClass).thenApply(value -> value == null ? null : this.mapToEntity(value, entityClass)));
    }

    private CallResultMapper<Object, SingleValueCallResult<Object>> getAutoResultMapper(Optional<TarantoolSpaceMetadata> spaceMetadata) {
        MessagePackMapper copiedMapper = this.mapper.copy();
        return this.mapperFactoryFactory.createMapper(this.mapper).buildSingleValueResultMapper((MessagePackValueMapper)this.mapperFactoryFactory.createMapper(this.mapper, (TarantoolSpaceMetadata)spaceMetadata.orElse(null)).withArrayValueToTarantoolTupleResultConverter().withRowsMetadataToTarantoolTupleResultConverter().buildCallResultMapper(copiedMapper), Object.class);
    }

    @Override
    public <T> T callForObject(String functionName, List<?> parameters, Class<T> entityClass, String spaceName) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Optional spaceMetadata = this.tarantoolClient.metadata().getSpaceByName(spaceName);
        CallResultMapper<Object, SingleValueCallResult<Object>> resultMapper = this.getAutoResultMapper(spaceMetadata);
        return (T)this.executeSync(() -> this.tarantoolClient.callForSingleResult(functionName, this.mapParameters(parameters), resultMapper).thenApply(value -> {
            if (value == null) {
                return null;
            }
            if (value instanceof TarantoolResult) {
                return this.mapToEntity(((TarantoolResult)value).get(0), entityClass);
            }
            return this.mapToEntity(value, entityClass);
        }));
    }

    @Override
    public <T> List<T> callForObjectList(String functionName, List<?> parameters, Class<T> entityClass, String spaceName) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Optional spaceMetadata = this.tarantoolClient.metadata().getSpaceByName(spaceName);
        CallResultMapper<Object, SingleValueCallResult<Object>> resultMapper = this.getAutoResultMapper(spaceMetadata);
        return (List)this.executeSync(() -> this.tarantoolClient.callForSingleResult(functionName, this.mapParameters(parameters), resultMapper).thenApply(values -> {
            if (values == null) {
                return null;
            }
            return ((List)values).stream().map(t -> this.mapToEntity(t, entityClass)).collect(Collectors.toList());
        }));
    }

    @Override
    public <T> List<T> callForObjectList(String functionName, List<?> parameters, ValueConverter<Value, T> entityConverter) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityConverter, (String)"Entity converter must not be null!");
        return (List)this.executeSync(this.getCustomResultSupplier(functionName, parameters, (MessagePackObjectMapper)this.getMessagePackMapper(), entityConverter));
    }

    @Override
    public <T> List<T> callForObjectList(String functionName, List<?> parameters, Class<T> entityClass) {
        Assert.hasText((String)functionName, (String)"Function name must not be null or empty!");
        Assert.notNull(parameters, (String)"Parameters must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return (List)this.executeSync(() -> this.tarantoolClient.callForSingleResult(functionName, this.mapParameters(parameters), (MessagePackObjectMapper)this.getMessagePackMapper(), this.getListValueConverter(entityClass)));
    }

    @Override
    public <T> T callForTuple(String functionName, Class<T> entityType) {
        return this.callForTuple(functionName, Collections.emptyList(), "", entityType);
    }

    @Override
    public <T> T callForTuple(String functionName, ValueConverter<Value, T> entityConverter) {
        return this.callForTuple(functionName, Collections.emptyList(), entityConverter);
    }

    @Override
    public <T> T callForTuple(String functionName, Object[] parameters, Class<T> entityType) {
        return this.callForTuple(functionName, Arrays.asList(parameters), "", entityType);
    }

    @Override
    public <T> T callForTuple(String functionName, List<?> parameters, Class<T> entityType) {
        return this.callForTuple(functionName, parameters, "", entityType);
    }

    @Override
    public <T> T callForTuple(String functionName, Object[] parameters, ValueConverter<Value, T> entityConverter) {
        return this.callForTuple(functionName, Arrays.asList(parameters), entityConverter);
    }

    @Override
    public <T> T callForTuple(String functionName, Object[] parameters, String spaceName, Class<T> entityType) {
        return this.callForTuple(functionName, Arrays.asList(parameters), spaceName, entityType);
    }

    @Override
    public <T> T callForTuple(String functionName, String spaceName, Class<T> entityType) {
        return this.callForTuple(functionName, Collections.emptyList(), spaceName, entityType);
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, Object[] parameters, ValueConverter<Value, T> entityConverter) {
        return this.callForTupleList(functionName, Arrays.asList(parameters), entityConverter);
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, List<?> parameters, Class<T> entityType) {
        return this.callForTupleList(functionName, Collections.emptyList(), "", entityType);
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, String spaceName, Class<T> entityType) {
        return this.callForTupleList(functionName, Collections.emptyList(), spaceName, entityType);
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, ValueConverter<Value, T> entityConverter) {
        return this.callForTupleList(functionName, Collections.emptyList(), entityConverter);
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, Object[] parameters, Class<T> entityType) {
        return this.callForTupleList(functionName, Arrays.asList(parameters), "", entityType);
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, Object[] parameters, String spaceName, Class<T> entityType) {
        return this.callForTupleList(functionName, Arrays.asList(parameters), spaceName, entityType);
    }

    @Override
    public <T> List<T> callForTupleList(String functionName, Class<T> entityType) {
        return this.callForTupleList(functionName, Collections.emptyList(), "", entityType);
    }

    @Override
    public <T> T callForObject(String functionName, Class<T> entityType) {
        return this.callForObject(functionName, Collections.emptyList(), entityType);
    }

    @Override
    public <T> T callForObject(String functionName, ValueConverter<Value, T> entityConverter) {
        return this.callForObject(functionName, Collections.emptyList(), entityConverter);
    }

    @Override
    public <T> T callForObject(String functionName, Object[] parameters, Class<T> entityType) {
        return this.callForObject(functionName, Arrays.asList(parameters), entityType);
    }

    @Override
    public <T> T callForObject(String functionName, Object[] parameters, Class<T> entityType, String spaceName) {
        return this.callForObject(functionName, Arrays.asList(parameters), entityType, spaceName);
    }

    @Override
    public <T> T callForObject(String functionName, Object[] parameters, ValueConverter<Value, T> entityConverter) {
        return this.callForObject(functionName, Arrays.asList(parameters), entityConverter);
    }

    @Override
    public <T> List<T> callForObjectList(String functionName, Object[] parameters, Class<T> entityClass) {
        return this.callForObjectList(functionName, Arrays.asList(parameters), entityClass);
    }

    @Override
    public <T> List<T> callForObjectList(String functionName, Object[] parameters, Class<T> entityClass, String spaceName) {
        return this.callForObjectList(functionName, Arrays.asList(parameters), entityClass, spaceName);
    }

    @Override
    public <T> List<T> callForObjectList(String functionName, Object[] parameters, ValueConverter<Value, T> entityConverter) {
        return this.callForObjectList(functionName, Arrays.asList(parameters), entityConverter);
    }

    @Override
    public <T> List<T> callForObjectList(String functionName, Class<T> entityType) {
        return this.callForObjectList(functionName, Collections.emptyList(), entityType);
    }

    @Override
    public <T> List<T> callForObjectList(String functionName, ValueConverter<Value, T> entityConverter) {
        return this.callForObjectList(functionName, Collections.emptyList(), entityConverter);
    }
}

