/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core;

import io.tarantool.driver.api.conditions.Conditions;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentProperty;
import org.springframework.util.Assert;

public final class TarantoolTemplateUtils {
    static Conditions idQueryFromTuple(TarantoolTuple tuple, TarantoolPersistentEntity<?> entity) {
        List idValue = tuple.getFields();
        if (entity != null) {
            TarantoolPersistentProperty idProperty = (TarantoolPersistentProperty)entity.getIdProperty();
            if (idProperty == null) {
                throw new MappingException("No ID property specified in persistent entity " + entity.getType());
            }
            Object fieldValue = tuple.getObject(idProperty.getFieldName(), idProperty.getType()).orElseThrow(() -> new MappingException("ID property value is null"));
            idValue = Collections.singletonList(fieldValue);
        }
        return Conditions.indexEquals((int)0, (List)idValue);
    }

    static <T> List<?> getIndexPartValues(T source, TarantoolPersistentEntity<?> entity) {
        return entity.hasTarantoolIdClassAnnotation() ? TarantoolTemplateUtils.getIndexPartsFromCompositeIdValue(source, entity) : Collections.singletonList(source);
    }

    static List<?> getIndexPartsFromCompositeIdValue(Object idValue, TarantoolPersistentEntity<?> entity) {
        Optional<Class<?>> idClass = entity.getTarantoolIdClass();
        Assert.isTrue((boolean)idClass.isPresent(), (String)("@TarantoolIdClass is not specified for entity " + entity));
        return entity.getCompositeIdParts(idValue);
    }

    private TarantoolTemplateUtils() {
    }
}

