/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.convert;

import java.util.Collections;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.tarantool.core.convert.TarantoolConverter;
import org.springframework.data.tarantool.core.convert.TarantoolCustomConversions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractTarantoolConverter
implements TarantoolConverter,
InitializingBean {
    protected final GenericConversionService conversionService;
    protected CustomConversions conversions;
    protected EntityInstantiators instantiators = new EntityInstantiators();

    public AbstractTarantoolConverter(@Nullable CustomConversions conversions) {
        this.conversionService = new GenericConversionService();
        DefaultConversionService.addCollectionConverters((ConverterRegistry)this.conversionService);
        this.conversions = conversions == null ? new TarantoolCustomConversions(Collections.emptyList()) : conversions;
    }

    public void setCustomConversions(CustomConversions conversions) {
        Assert.notNull((Object)conversions, (String)"Conversions must not be null!");
        this.conversions = conversions;
    }

    public void setInstantiators(@Nullable EntityInstantiators instantiators) {
        this.instantiators = instantiators == null ? new EntityInstantiators() : instantiators;
    }

    @Override
    public CustomConversions getCustomConversions() {
        return this.conversions;
    }

    @Override
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void afterPropertiesSet() {
        this.conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }
}

