/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.convert;

import java.time.Instant;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public class DateConverters {
    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        boolean useISOStringConverterForDate = Boolean.parseBoolean(System.getProperty("org.springframework.data.couchbase.useISOStringConverterForDate", "false"));
        if (useISOStringConverterForDate) {
            converters.add(DateToStringConverter.INSTANCE);
        } else {
            converters.add(DateToLongConverter.INSTANCE);
        }
        converters.add(SerializedObjectToDateConverter.INSTANCE);
        converters.add(CalendarToLongConverter.INSTANCE);
        converters.add(NumberToCalendarConverter.INSTANCE);
        return converters;
    }

    @ReadingConverter
    public static enum NumberToCalendarConverter implements Converter<Number, Calendar>
    {
        INSTANCE;


        public Calendar convert(Number source) {
            if (source == null) {
                return null;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(source.longValue() * 1000L);
            return calendar;
        }
    }

    @WritingConverter
    public static enum CalendarToLongConverter implements Converter<Calendar, Long>
    {
        INSTANCE;


        public Long convert(Calendar source) {
            return source == null ? null : Long.valueOf(source.getTimeInMillis() / 1000L);
        }
    }

    @WritingConverter
    public static enum DateToLongConverter implements Converter<Date, Long>
    {
        INSTANCE;


        public Long convert(Date source) {
            return source == null ? null : Long.valueOf(source.getTime());
        }
    }

    @WritingConverter
    public static enum DateToStringConverter implements Converter<Date, String>
    {
        INSTANCE;


        public String convert(Date source) {
            return source == null ? null : source.toInstant().toString();
        }
    }

    @ReadingConverter
    public static enum SerializedObjectToDateConverter implements Converter<Object, Date>
    {
        INSTANCE;


        public Date convert(Object source) {
            if (source == null) {
                return null;
            }
            if (source instanceof Number) {
                Date date = new Date();
                date.setTime(((Number)source).longValue());
                return date;
            }
            if (source instanceof String) {
                return Date.from(Instant.parse((String)source).atZone(ZoneId.systemDefault()).toInstant());
            }
            return null;
        }
    }
}

