/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.convert;

import io.tarantool.driver.api.tuple.TarantoolTuple;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.tarantool.core.convert.AbstractTarantoolConverter;
import org.springframework.data.tarantool.core.convert.MappingTarantoolReadConverter;
import org.springframework.data.tarantool.core.convert.MappingTarantoolWriteConverter;
import org.springframework.data.tarantool.core.convert.TarantoolMapTypeAliasAccessor;
import org.springframework.data.tarantool.core.convert.TarantoolMapTypeMapper;
import org.springframework.data.tarantool.core.convert.TarantoolTupleTypeMapper;
import org.springframework.data.tarantool.core.mapping.TarantoolMappingContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MappingTarantoolConverter
extends AbstractTarantoolConverter
implements ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final TarantoolMappingContext mappingContext;
    private final TarantoolMapTypeAliasAccessor mapTypeAliasAccessor;
    private final TarantoolTupleTypeMapper typeMapper;
    private final MappingTarantoolReadConverter readConverter;
    private final MappingTarantoolWriteConverter writeConverter;
    private final TarantoolMapTypeMapper mapTypeMapper;
    private ApplicationContext applicationContext;
    @Nullable
    private EntityCallbacks entityCallbacks;

    public MappingTarantoolConverter(TarantoolMappingContext mappingContext, TarantoolMapTypeAliasAccessor typeAliasAccessor, CustomConversions conversions) {
        super(conversions);
        this.mappingContext = mappingContext;
        this.mapTypeAliasAccessor = typeAliasAccessor;
        this.typeMapper = new TarantoolTupleTypeMapper();
        this.mapTypeMapper = new TarantoolMapTypeMapper();
        this.readConverter = new MappingTarantoolReadConverter(this.instantiators, mappingContext, (TypeMapper<TarantoolTuple>)this.typeMapper, (TypeMapper<Map<String, Object>>)this.mapTypeMapper, this.mapTypeAliasAccessor, conversions, this.conversionService);
        this.writeConverter = new MappingTarantoolWriteConverter(mappingContext, this.typeMapper, conversions, this.conversionService);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        if (this.entityCallbacks == null) {
            this.setEntityCallbacks(EntityCallbacks.create((BeanFactory)applicationContext));
        }
    }

    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null");
        this.entityCallbacks = entityCallbacks;
    }

    public <R> R read(Class<R> clazz, Object source) {
        return this.readConverter.read(clazz, source);
    }

    public void write(Object source, Object target) {
        this.writeConverter.write(source, target);
    }

    @Override
    public TarantoolMappingContext getMappingContext() {
        return this.mappingContext;
    }
}

