/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.convert;

import io.tarantool.driver.api.tuple.TarantoolTuple;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.tarantool.core.convert.TarantoolMapTypeMapper;
import org.springframework.data.tarantool.core.mapping.TarantoolMappingContext;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class MappingTarantoolReadConverter
implements EntityReader<Object, Object> {
    private final EntityInstantiators instantiators;
    private final TarantoolMappingContext mappingContext;
    private final TypeMapper<TarantoolTuple> typeMapper;
    private final TypeMapper<Map<String, Object>> mapTypeMapper;
    private final TypeAliasAccessor<Map<String, Object>> mapTypeAliasAccessor;
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;

    public MappingTarantoolReadConverter(EntityInstantiators instantiators, TarantoolMappingContext mappingContext, TypeMapper<TarantoolTuple> typeMapper, TypeMapper<Map<String, Object>> mapTypeMapper, TypeAliasAccessor<Map<String, Object>> mapTypeAliasAccessor, CustomConversions conversions, GenericConversionService conversionService) {
        this.instantiators = instantiators;
        this.mappingContext = mappingContext;
        this.typeMapper = typeMapper;
        this.mapTypeMapper = mapTypeMapper;
        this.mapTypeAliasAccessor = mapTypeAliasAccessor;
        this.conversions = conversions;
        this.conversionService = conversionService;
    }

    @Nullable
    private <R> R read(Class<R> targetClass, @Nullable Map<String, Object> source) {
        if (source == null) {
            return null;
        }
        TypeInformation typeToUse = this.mapTypeMapper.readType(source, (TypeInformation)ClassTypeInformation.from(targetClass));
        Class rawType = typeToUse.getType();
        if (this.conversions.hasCustomReadTarget(Map.class, rawType)) {
            return (R)this.conversionService.convert(source, rawType);
        }
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
        TarantoolPropertyValueProvider propertyValueProvider = this.getPropertyValueProvider(source);
        ConvertingPropertyAccessor<?> accessor = this.getConvertingPropertyAccessor(entity, propertyValueProvider);
        return this.convertProperties(entity, propertyValueProvider, (PersistentPropertyAccessor<?>)accessor);
    }

    @Nullable
    public <R> R read(Class<R> targetClass, @Nullable Object source) {
        TypeInformation typeToUse;
        if (source == null) {
            return null;
        }
        if (targetClass.equals(Void.TYPE)) {
            throw new MappingException(String.format("Cannot map object of type %s to object of type %s", source.getClass(), targetClass));
        }
        if (source instanceof TarantoolTuple) {
            TarantoolTuple tuple = (TarantoolTuple)source;
            if (!tuple.hasMetadata()) {
                throw new MappingException("Cannot map tuple without field metadata to an entity of type " + targetClass);
            }
            typeToUse = this.typeMapper.readType((Object)tuple, (TypeInformation)ClassTypeInformation.from(targetClass));
            Class rawType = typeToUse.getType();
            if (this.conversions.hasCustomReadTarget(TarantoolTuple.class, rawType)) {
                return (R)this.conversionService.convert(source, rawType);
            }
        } else if (source instanceof Map) {
            typeToUse = this.mapTypeMapper.readType((Object)((Map)source), (TypeInformation)ClassTypeInformation.from(targetClass));
        } else {
            if (source.getClass().equals(targetClass)) {
                return (R)source;
            }
            throw new MappingException(String.format("Cannot map object of type %s to object of type %s", source.getClass(), targetClass));
        }
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(typeToUse);
        TarantoolPropertyValueProvider propertyValueProvider = this.getPropertyValueProvider(source);
        ConvertingPropertyAccessor<?> accessor = this.getConvertingPropertyAccessor(entity, propertyValueProvider);
        return this.convertProperties(entity, propertyValueProvider, (PersistentPropertyAccessor<?>)accessor);
    }

    private TarantoolPropertyValueProvider getPropertyValueProvider(Object source) {
        return new TarantoolPropertyValueProvider(source, this.conversions, (ConversionService)this.conversionService);
    }

    private ParameterValueProvider<TarantoolPersistentProperty> getParameterProvider(TarantoolPersistentEntity<?> entity, TarantoolPropertyValueProvider propertyValueProvider) {
        return new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)propertyValueProvider, null);
    }

    private ConvertingPropertyAccessor<?> getConvertingPropertyAccessor(TarantoolPersistentEntity<?> entity, TarantoolPropertyValueProvider propertyValueProvider) {
        EntityInstantiator instantiator = this.instantiators.getInstantiatorFor(entity);
        ParameterValueProvider<TarantoolPersistentProperty> provider = this.getParameterProvider(entity, propertyValueProvider);
        Object instance = instantiator.createInstance(entity, provider);
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        return new ConvertingPropertyAccessor(accessor, (ConversionService)this.conversionService);
    }

    private <R> R convertProperties(TarantoolPersistentEntity<?> entity, TarantoolPropertyValueProvider propertyValueProvider, PersistentPropertyAccessor<?> propertyAccessor) {
        entity.doWithProperties(property -> {
            if (entity.isCreatorArgument(property)) {
                return;
            }
            this.setProperty((TarantoolPersistentProperty)property, propertyValueProvider, propertyAccessor);
        });
        entity.doWithAssociations(association -> {
            TarantoolPersistentProperty inverseProperty = (TarantoolPersistentProperty)association.getInverse();
            this.setProperty(inverseProperty, propertyValueProvider, propertyAccessor);
        });
        return (R)propertyAccessor.getBean();
    }

    private void setProperty(TarantoolPersistentProperty property, TarantoolPropertyValueProvider propertyValueProvider, PersistentPropertyAccessor<?> propertyAccessor) {
        Object propValue = propertyValueProvider.getPropertyValue(property);
        if (property.getType().isPrimitive() && propValue == null) {
            return;
        }
        propertyAccessor.setProperty((PersistentProperty)property, propValue);
    }

    private class TarantoolPropertyValueProvider
    implements PropertyValueProvider<TarantoolPersistentProperty> {
        private Object source;
        private CustomConversions conversions;
        private ConversionService conversionService;
        private final TypeMapper<Map<String, Object>> mapTypeMapper;

        TarantoolPropertyValueProvider(Object source, CustomConversions conversions, ConversionService conversionService) {
            this.source = source;
            this.conversions = conversions;
            this.conversionService = conversionService;
            this.mapTypeMapper = new TarantoolMapTypeMapper();
        }

        @Nullable
        public <R> R getPropertyValue(TarantoolPersistentProperty property) {
            if (this.source == null) {
                return null;
            }
            TypeInformation propType = property.getTypeInformation();
            Class propClass = propType.getType();
            Optional customTargetClass = this.conversions.getCustomWriteTarget(propClass);
            String fieldName = property.getFieldName();
            if (this.source instanceof TarantoolTuple) {
                Object value = propType.isCollectionLike() ? ((TarantoolTuple)this.source).getList(fieldName) : (propType.isMap() ? ((TarantoolTuple)this.source).getMap(fieldName) : (customTargetClass.isPresent() && this.conversions.hasCustomReadTarget((Class)customTargetClass.get(), propClass) && ((TarantoolTuple)this.source).canGetObject(fieldName, (Class)customTargetClass.get()) ? ((TarantoolTuple)this.source).getObject(fieldName, (Class)customTargetClass.get()).orElse(null) : (((TarantoolTuple)this.source).canGetObject(fieldName, propClass) ? ((TarantoolTuple)this.source).getObject(fieldName, propClass).orElse(null) : ((TarantoolTuple)this.source).getObject(fieldName).orElse(null))));
                return this.readValue(value, propType);
            }
            if (this.source instanceof Map) {
                return this.readValue(((Map)this.source).get(fieldName), propType);
            }
            throw new MappingException("Cannot read properties from a source of type " + this.source.getClass());
        }

        private <R> R readValue(@Nullable Object source, TypeInformation<?> propertyType) {
            Assert.notNull(propertyType, (String)"Target type must not be null!");
            if (source == null) {
                return null;
            }
            Class targetClass = propertyType.getType();
            if (this.conversions.hasCustomReadTarget(source.getClass(), targetClass) || this.conversions.isSimpleType(targetClass) && this.conversionService.canConvert(source.getClass(), targetClass)) {
                return (R)this.conversionService.convert(source, targetClass);
            }
            if (propertyType.isCollectionLike()) {
                return this.convertCollection(this.asCollection(source), propertyType);
            }
            if (propertyType.isMap()) {
                return this.convertMap((Map)source, propertyType);
            }
            return (R)this.convertIfNeeded(source, propertyType);
        }

        private Collection<?> asCollection(Object source) {
            if (source instanceof Collection) {
                return (Collection)source;
            }
            return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
        }

        private <R> R convertCustomType(final Map<String, Object> source, TypeInformation<?> propertyType) {
            if (source == null) {
                return null;
            }
            TypeInformation typeToUse = this.mapTypeMapper.readType(source, propertyType);
            TarantoolPersistentEntity entity = (TarantoolPersistentEntity)MappingTarantoolReadConverter.this.mappingContext.getPersistentEntity(typeToUse);
            if (this.shouldDefaultToMap(source, entity)) {
                return (R)source;
            }
            PropertyValueProvider<TarantoolPersistentProperty> propertyValueProvider = new PropertyValueProvider<TarantoolPersistentProperty>(){

                public <T> T getPropertyValue(TarantoolPersistentProperty property) {
                    TypeInformation propType = property.getTypeInformation();
                    return (T)TarantoolPropertyValueProvider.this.readValue(source.get(property.getFieldName()), propType);
                }
            };
            EntityInstantiator instantiator = MappingTarantoolReadConverter.this.instantiators.getInstantiatorFor((PersistentEntity)entity);
            PersistentEntityParameterValueProvider provider = new PersistentEntityParameterValueProvider((PersistentEntity)entity, (PropertyValueProvider)propertyValueProvider, null);
            Object instance = instantiator.createInstance((PersistentEntity)entity, (ParameterValueProvider)provider);
            ConvertingPropertyAccessor propertyAccessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(instance), this.conversionService);
            entity.doWithProperties(arg_0 -> TarantoolPropertyValueProvider.lambda$convertCustomType$0(entity, (PropertyValueProvider)propertyValueProvider, (PersistentPropertyAccessor)propertyAccessor, arg_0));
            return (R)propertyAccessor.getBean();
        }

        private boolean shouldDefaultToMap(Map<String, Object> source, TarantoolPersistentEntity<?> entity) {
            return entity == null && !MappingTarantoolReadConverter.this.mapTypeAliasAccessor.readAliasFrom(source).isPresent();
        }

        private <R> R convertCollection(Collection<?> source, TypeInformation<?> propertyType) {
            Class collectionClass = propertyType.getType();
            TypeInformation elementType = propertyType.getComponentType();
            Class elementClass = elementType == null ? null : elementType.getType();
            ArrayList items = collectionClass.isArray() ? new ArrayList() : CollectionFactory.createCollection((Class)collectionClass, (Class)elementClass, (int)source.size());
            source.forEach(item -> items.add(this.readValue(item, elementType)));
            return (R)this.convertIfNeeded(items, propertyType);
        }

        private <R> R convertMap(Map<String, Object> source, TypeInformation<?> propertyType) {
            Class mapClass = propertyType.getType();
            TypeInformation keyType = propertyType.getComponentType();
            Class keyClass = keyType == null ? null : keyType.getType();
            TypeInformation mapValueType = propertyType.getMapValueType();
            Class mapType = this.mapTypeMapper.readType(source, propertyType).getType();
            HashMap converted = mapType != null ? CollectionFactory.createMap((Class)mapClass, (Class)keyClass, (int)source.keySet().size()) : new HashMap();
            source.forEach((key, value) -> converted.put(key, this.readValue(value, mapValueType)));
            return (R)this.convertIfNeeded(converted, propertyType);
        }

        private Object convertIfNeeded(Object value, TypeInformation<?> propertyType) {
            Class targetClass = propertyType.getType();
            if (Enum.class.isAssignableFrom(targetClass)) {
                return Enum.valueOf(targetClass, value.toString());
            }
            if (value instanceof Map && !propertyType.isMap()) {
                return this.convertCustomType((Map)value, propertyType);
            }
            return value;
        }

        private static /* synthetic */ void lambda$convertCustomType$0(TarantoolPersistentEntity entity, PropertyValueProvider propertyValueProvider, PersistentPropertyAccessor propertyAccessor, TarantoolPersistentProperty property) {
            if (entity.isCreatorArgument(property)) {
                return;
            }
            Object propValue = propertyValueProvider.getPropertyValue((PersistentProperty)property);
            if (property.getType().isPrimitive() && propValue == null) {
                return;
            }
            propertyAccessor.setProperty((PersistentProperty)property, propValue);
        }
    }
}

