/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.convert;

import io.tarantool.driver.api.tuple.TarantoolTuple;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityWriter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.tarantool.core.convert.TarantoolMapTypeMapper;
import org.springframework.data.tarantool.core.convert.TarantoolTupleTypeMapper;
import org.springframework.data.tarantool.core.mapping.TarantoolMappingContext;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentProperty;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class MappingTarantoolWriteConverter
implements EntityWriter<Object, Object> {
    private final TarantoolTupleTypeMapper typeMapper;
    private final TarantoolMappingContext mappingContext;
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;
    private final TarantoolMapTypeMapper mapTypeMapper;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public MappingTarantoolWriteConverter(TarantoolMappingContext mappingContext, TarantoolTupleTypeMapper typeMapper, CustomConversions conversions, GenericConversionService conversionService) {
        this.typeMapper = typeMapper;
        this.mappingContext = mappingContext;
        this.mapTypeMapper = new TarantoolMapTypeMapper();
        this.conversions = conversions;
        this.conversionService = conversionService;
    }

    public void write(Object source, Object target) {
        if (source == null) {
            return;
        }
        if (target instanceof TarantoolTuple) {
            this.write(source, (TarantoolTuple)target);
        } else if (source instanceof Collection && target instanceof Collection) {
            this.write((Collection)source, (Collection)target);
        } else {
            throw new MappingException(String.format("Unknown write target [%s]", ObjectUtils.nullSafeClassName((Object)target)));
        }
    }

    private void write(Object source, TarantoolTuple target) {
        Optional customTarget = this.conversions.getCustomWriteTarget(source.getClass(), target.getClass());
        if (customTarget.isPresent()) {
            TarantoolTuple result = (TarantoolTuple)this.conversionService.convert(source, TarantoolTuple.class);
            this.setFields(target, result);
            this.typeMapper.writeType(ClassUtils.getUserClass(source.getClass()), target);
            return;
        }
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        if (entity == null) {
            throw new MappingException("No mapping metadata found for entity ".concat(source.getClass().getName()));
        }
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(source), (ConversionService)this.conversionService);
        Map<String, Object> convertedProperties = this.convertProperties(entity, accessor);
        convertedProperties.forEach((arg_0, arg_1) -> ((TarantoolTuple)target).putObject(arg_0, arg_1));
    }

    private void write(Collection<Object> parameters, Collection<Object> mappedParameters) {
        mappedParameters.clear();
        for (Object parameter : parameters) {
            if (parameter == null) {
                mappedParameters.add(null);
                continue;
            }
            TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getPersistentEntity(parameter.getClass());
            Object type = entity == null ? ClassTypeInformation.from(parameter.getClass()) : entity.getTypeInformation();
            mappedParameters.add(this.getValueToWrite(parameter, (TypeInformation<?>)type));
        }
    }

    private void setFields(TarantoolTuple target, TarantoolTuple other) {
        target.getFields().clear();
        target.getFields().addAll(other.getFields());
    }

    private Map<String, Object> convertProperties(TarantoolPersistentEntity<?> entity, ConvertingPropertyAccessor<?> accessor) {
        HashMap<String, Object> target = new HashMap<String, Object>();
        entity.doWithProperties(property -> {
            Object value = accessor.getProperty(property);
            if (!property.isWritable()) {
                return;
            }
            Object valueToWrite = this.getValueToWrite(value, property.getTypeInformation());
            if (valueToWrite != null) {
                target.put(property.getFieldName(), valueToWrite);
            }
        });
        entity.doWithAssociations(association -> {
            TarantoolPersistentProperty inverse = (TarantoolPersistentProperty)association.getInverse();
            Object value = accessor.getProperty((PersistentProperty)inverse);
            Object valueToWrite = this.getValueToWrite(value, inverse.getTypeInformation());
            if (valueToWrite != null) {
                target.put(inverse.getFieldName(), valueToWrite);
            }
        });
        return target;
    }

    private Object getValueToWrite(Object value, TypeInformation<?> type) {
        if (value == null) {
            return null;
        }
        if (type == null || this.conversions.isSimpleType(value.getClass())) {
            return this.getSimpleValueToWrite(value);
        }
        return this.getNonSimpleValueToWrite(value, type);
    }

    private Object getSimpleValueToWrite(Object value) {
        Optional customTarget = this.conversions.getCustomWriteTarget(value.getClass());
        return customTarget.map(aClass -> this.conversionService.convert(value, aClass)).orElse(value);
    }

    private Object getNonSimpleValueToWrite(Object value, TypeInformation<?> type) {
        ClassTypeInformation valueType = ClassTypeInformation.from(value.getClass());
        if (valueType.isCollectionLike()) {
            return this.convertCollection(MappingTarantoolWriteConverter.asCollection(value), type);
        }
        if (valueType.isMap()) {
            return this.convertMap(this.asMap(value), type);
        }
        Optional basicTargetType = this.conversions.getCustomWriteTarget(value.getClass());
        return basicTargetType.map(aClass -> this.conversionService.convert(value, aClass)).orElseGet(() -> this.convertCustomType(value, type));
    }

    private static Collection<?> asCollection(Object source) {
        if (source instanceof Collection) {
            return (Collection)source;
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    private Map<Object, Object> asMap(Object value) {
        return (Map)value;
    }

    private List<Object> convertCollection(Collection<?> source, TypeInformation<?> type) {
        Assert.notNull(source, (String)"Given collection must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        TypeInformation componentType = type.getComponentType();
        return source.stream().map(element -> this.getValueToWrite(element, componentType)).collect(Collectors.toList());
    }

    private Map<String, Object> convertMap(Map<Object, Object> source, TypeInformation<?> type) {
        Assert.notNull(source, (String)"Given map must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        return source.entrySet().stream().collect(HashMap::new, (m, e) -> {
            Object key = e.getKey();
            Object value = e.getValue();
            if (!this.conversions.isSimpleType(key.getClass())) {
                throw new MappingException("Cannot use a complex object as a key value.");
            }
            String simpleKey = key.toString();
            Object convertedValue = this.getValueToWrite(value, type.getMapValueType());
            m.put(simpleKey, convertedValue);
        }, HashMap::putAll);
    }

    private Map<String, Object> convertCustomType(Object source, TypeInformation<?> type) {
        Assert.notNull((Object)source, (String)"Given source must not be null!");
        Assert.notNull(type, (String)"Given type must not be null!");
        Optional customTarget = this.conversions.getCustomWriteTarget(source.getClass(), type.getType());
        if (customTarget.isPresent()) {
            Map result = (Map)this.conversionService.convert(source, Map.class);
            this.mapTypeMapper.writeType(ClassUtils.getUserClass(source.getClass()), result);
            return result;
        }
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getPersistentEntity(source.getClass());
        if (entity == null) {
            throw new MappingException("No mapping metadata found for entity ".concat(source.getClass().getName()));
        }
        ConvertingPropertyAccessor accessor = new ConvertingPropertyAccessor(entity.getPropertyAccessor(source), (ConversionService)this.conversionService);
        Map<String, Object> result = this.convertProperties(entity, accessor);
        return result;
    }
}

