/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;

public class TarantoolMessagePackConverters {
    public static Collection<Converter<?, ?>> getConvertersToRegister() {
        ArrayList converters = new ArrayList();
        converters.add(IntegerToLongConverter.INSTANCE);
        converters.add(ShortToLongConverter.INSTANCE);
        converters.add(ShortToIntegerConverter.INSTANCE);
        converters.add(FloatToDoubleConverter.INSTANCE);
        return converters;
    }

    static enum FloatToDoubleConverter implements Converter<Float, Double>
    {
        INSTANCE;


        public Double convert(Float source) {
            return source.floatValue();
        }
    }

    static enum ShortToIntegerConverter implements Converter<Short, Integer>
    {
        INSTANCE;


        public Integer convert(Short source) {
            return (int)source;
        }
    }

    static enum ShortToLongConverter implements Converter<Short, Long>
    {
        INSTANCE;


        public Long convert(Short source) {
            return (long)source;
        }
    }

    static enum IntegerToLongConverter implements Converter<Integer, Long>
    {
        INSTANCE;


        public Long convert(Integer source) {
            return (long)source;
        }
    }
}

