/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.TargetAwareIdentifierAccessor;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.tarantool.core.mapping.MappingUtils;
import org.springframework.data.tarantool.core.mapping.TarantoolIdClass;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentProperty;
import org.springframework.data.tarantool.core.mapping.Tuple;
import org.springframework.data.tarantool.exceptions.TarantoolEntityOperationException;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class BasicTarantoolPersistentEntity<T>
extends BasicPersistentEntity<T, TarantoolPersistentProperty>
implements TarantoolPersistentEntity<T> {
    public BasicTarantoolPersistentEntity(TypeInformation<T> information) {
        super(information);
    }

    @Override
    public String getSpaceName() {
        Tuple annotationField = this.getType().getAnnotation(Tuple.class);
        if (annotationField != null && StringUtils.hasText((String)annotationField.value())) {
            return annotationField.value();
        }
        return MappingUtils.camelCaseToSnakeCase(this.getType().getSimpleName());
    }

    @Override
    public boolean hasTupleAnnotation() {
        return this.getType().getAnnotation(Tuple.class) != null;
    }

    @Override
    public boolean hasTarantoolIdClassAnnotation() {
        return this.getType().getAnnotation(TarantoolIdClass.class) != null;
    }

    @Override
    public Optional<Class<?>> getTarantoolIdClass() {
        if (!this.hasTarantoolIdClassAnnotation()) {
            return Optional.empty();
        }
        return Optional.of(this.getType().getAnnotation(TarantoolIdClass.class).value());
    }

    protected TarantoolPersistentProperty returnPropertyIfBetterIdPropertyCandidateOrNull(TarantoolPersistentProperty property) {
        if (this.hasTarantoolIdClassAnnotation()) {
            return property.isIdProperty() ? property : null;
        }
        return (TarantoolPersistentProperty)super.returnPropertyIfBetterIdPropertyCandidateOrNull((PersistentProperty)property);
    }

    @Override
    public List<?> getCompositeIdParts(Object idValue) {
        LinkedList<Object> idParts = new LinkedList<Object>();
        for (Field field : idValue.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            TarantoolPersistentProperty property = (TarantoolPersistentProperty)this.getPersistentProperty(field.getName());
            Assert.notNull((Object)property, (String)("Property " + field.getName() + " does not exist in entity " + this));
            ReflectionUtils.makeAccessible((Field)field);
            try {
                idParts.add(field.get(idValue));
            }
            catch (IllegalAccessException e) {
                throw new TarantoolEntityOperationException(this.getClass(), "Failed to get field " + field.getName(), (Throwable)e);
            }
        }
        return idParts;
    }

    public IdentifierAccessor getIdentifierAccessor(Object bean) {
        if (this.hasTarantoolIdClassAnnotation()) {
            return new TarantoolCompositeIdentifierAccessor(this, bean);
        }
        return super.getIdentifierAccessor(bean);
    }

    private static class TarantoolCompositeIdentifierAccessor
    extends TargetAwareIdentifierAccessor {
        private final BasicTarantoolPersistentEntity<?> entity;
        private final Object bean;
        private final PersistentPropertyAccessor<Object> propertyAccessor;

        TarantoolCompositeIdentifierAccessor(BasicTarantoolPersistentEntity<?> entity, Object bean) {
            super(bean);
            this.entity = entity;
            this.bean = bean;
            this.propertyAccessor = entity.getPropertyAccessor(bean);
        }

        public Object getIdentifier() {
            Object id;
            Optional<Class<?>> entityIdClass = this.entity.getTarantoolIdClass();
            if (!entityIdClass.isPresent()) {
                return null;
            }
            Class<?> idClass = entityIdClass.get();
            if (idClass.isInstance(this.bean)) {
                return this.bean;
            }
            try {
                id = Objects.requireNonNull(idClass).newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new TarantoolEntityOperationException(this.entity.getName(), "Failed to create ID class instance", (Throwable)e);
            }
            for (Field field : idClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                TarantoolPersistentProperty property = (TarantoolPersistentProperty)this.entity.getPersistentProperty(field.getName());
                Assert.notNull((Object)property, (String)("Property '" + field.getName() + "' is null for " + this.entity));
                Object value = this.propertyAccessor.getProperty((PersistentProperty)property);
                ReflectionUtils.makeAccessible((Field)field);
                try {
                    field.set(id, value);
                }
                catch (IllegalAccessException e) {
                    throw new TarantoolEntityOperationException(this.entity.getName(), "Failed to set field " + field.getName(), (Throwable)e);
                }
            }
            return id;
        }
    }
}

