/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.mapping;

import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.FieldNamingStrategy;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.PropertyNameFieldNamingStrategy;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.tarantool.core.mapping.Field;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentProperty;
import org.springframework.util.StringUtils;

public class BasicTarantoolPersistentProperty
extends AnnotationBasedPersistentProperty<TarantoolPersistentProperty>
implements TarantoolPersistentProperty {
    private final FieldNamingStrategy fieldNamingStrategy;

    public BasicTarantoolPersistentProperty(Property property, TarantoolPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder, FieldNamingStrategy fieldNamingStrategy) {
        super(property, owner, simpleTypeHolder);
        this.fieldNamingStrategy = fieldNamingStrategy == null ? PropertyNameFieldNamingStrategy.INSTANCE : fieldNamingStrategy;
    }

    protected Association<TarantoolPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    @Override
    public String getFieldName() {
        java.lang.reflect.Field field = this.getField();
        Field annotationField = field.getAnnotation(Field.class);
        if (annotationField != null) {
            String value = annotationField.value();
            if (StringUtils.hasText((String)value)) {
                return value;
            }
            String name = annotationField.name();
            if (StringUtils.hasText((String)name)) {
                return name;
            }
        }
        return this.fieldNamingStrategy.getFieldName((PersistentProperty)this);
    }
}

