/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.query;

import io.tarantool.driver.exceptions.TarantoolAccessDeniedException;
import io.tarantool.driver.exceptions.TarantoolClientException;
import org.springframework.data.tarantool.core.TarantoolOperations;
import org.springframework.data.tarantool.core.mapping.BasicTarantoolPersistentEntity;
import org.springframework.data.tarantool.core.query.TarantoolQueryMethod;
import org.springframework.data.tarantool.core.query.TarantoolRepositoryQueryExecutor;

public class TarantoolObjectRepositoryQueryExecutor
implements TarantoolRepositoryQueryExecutor {
    private final TarantoolOperations operations;
    private final TarantoolQueryMethod queryMethod;

    public TarantoolObjectRepositoryQueryExecutor(TarantoolOperations operations, TarantoolQueryMethod queryMethod) {
        this.operations = operations;
        this.queryMethod = queryMethod;
    }

    @Override
    public Object execute(Object[] parameters) {
        Class returnedType;
        block5: {
            returnedType = this.queryMethod.getResultProcessor().getReturnedType().getReturnedType();
            if (this.operations.getMappingContext().hasPersistentEntityFor(returnedType)) {
                String spaceName = ((BasicTarantoolPersistentEntity)this.operations.getMappingContext().getRequiredPersistentEntity(returnedType)).getSpaceName();
                try {
                    if (this.queryMethod.isCollectionQuery()) {
                        return this.operations.callForObjectList(this.queryMethod.getQueryFunctionName(), parameters, returnedType, spaceName);
                    }
                    return this.operations.callForObject(this.queryMethod.getQueryFunctionName(), parameters, returnedType, spaceName);
                }
                catch (TarantoolClientException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof TarantoolAccessDeniedException) break block5;
                    throw ex;
                }
            }
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.operations.callForObjectList(this.queryMethod.getQueryFunctionName(), parameters, returnedType);
        }
        return this.operations.callForObject(this.queryMethod.getQueryFunctionName(), parameters, returnedType);
    }
}

