/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.query;

import java.lang.reflect.Method;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.tarantool.core.TarantoolOperations;
import org.springframework.data.tarantool.core.query.TarantoolObjectRepositoryQuery;
import org.springframework.data.tarantool.core.query.TarantoolQueryMethod;
import org.springframework.data.tarantool.core.query.TarantoolTupleRepositoryQuery;
import org.springframework.data.tarantool.repository.Query;
import org.springframework.data.tarantool.repository.TarantoolSerializationType;
import org.springframework.data.tarantool.repository.config.TarantoolRepositoryOperationsMapping;

public class TarantoolQueryLookupStrategy
implements QueryLookupStrategy {
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final TarantoolRepositoryOperationsMapping operationsMapping;

    public TarantoolQueryLookupStrategy(QueryMethodEvaluationContextProvider evaluationContextProvider, TarantoolRepositoryOperationsMapping operationsMapping) {
        this.evaluationContextProvider = evaluationContextProvider;
        this.operationsMapping = operationsMapping;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        TarantoolOperations operations = this.operationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
        TarantoolQueryMethod queryMethod = new TarantoolQueryMethod(method, metadata, projectionFactory);
        Query query = queryMethod.getQueryAnnotation();
        if (query != null && TarantoolSerializationType.TUPLE.equals((Object)query.output())) {
            return new TarantoolTupleRepositoryQuery(operations, queryMethod);
        }
        return new TarantoolObjectRepositoryQuery(operations, queryMethod);
    }
}

