/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.query;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.tarantool.repository.Query;

public class TarantoolQueryMethod
extends QueryMethod {
    private final Method method;
    private final RepositoryMetadata metadata;

    public TarantoolQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(method, metadata, factory);
        this.method = method;
        this.metadata = metadata;
    }

    public boolean hasQueryAnnotation() {
        return this.getQueryAnnotation() != null;
    }

    public Query getQueryAnnotation() {
        return (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.method, Query.class);
    }

    public String getQueryFunctionName() {
        if (this.getQueryAnnotation() == null) {
            return null;
        }
        return this.getQueryAnnotation().function();
    }
}

