/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.core.query;

import org.springframework.data.tarantool.core.TarantoolOperations;
import org.springframework.data.tarantool.core.mapping.BasicTarantoolPersistentEntity;
import org.springframework.data.tarantool.core.query.TarantoolQueryMethod;
import org.springframework.data.tarantool.core.query.TarantoolRepositoryQueryExecutor;

public class TarantoolTupleRepositoryQueryExecutor
implements TarantoolRepositoryQueryExecutor {
    private final TarantoolOperations operations;
    private final TarantoolQueryMethod queryMethod;

    public TarantoolTupleRepositoryQueryExecutor(TarantoolOperations operations, TarantoolQueryMethod queryMethod) {
        this.operations = operations;
        this.queryMethod = queryMethod;
    }

    @Override
    public Object execute(Object[] parameters) {
        Class returnedType = this.queryMethod.getReturnedObjectType();
        String spaceName = ((BasicTarantoolPersistentEntity)this.operations.getMappingContext().getRequiredPersistentEntity(returnedType)).getSpaceName();
        if (this.queryMethod.isCollectionQuery()) {
            return this.operations.callForTupleList(this.queryMethod.getQueryFunctionName(), parameters, spaceName, returnedType);
        }
        return this.operations.callForTuple(this.queryMethod.getQueryFunctionName(), parameters, spaceName, returnedType);
    }
}

