/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.repository.config;

import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.tarantool.repository.TarantoolRepository;
import org.springframework.data.tarantool.repository.support.TarantoolRepositoryFactoryBean;
import org.w3c.dom.Element;

public class TarantoolRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String TARANTOOL_TEMPLATE_REF = "tarantool-template-ref";

    public String getModuleName() {
        return "Tarantool";
    }

    protected String getModulePrefix() {
        return "tarantool";
    }

    public String getRepositoryFactoryBeanClassName() {
        return TarantoolRepositoryFactoryBean.class.getName();
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(TarantoolRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)TARANTOOL_TEMPLATE_REF, (String)"tarantoolOperations");
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        builder.addDependsOn("tarantoolRepositoryOperationsMapping");
        builder.addPropertyReference("tarantoolOperationsMapping", "tarantoolRepositoryOperationsMapping");
    }
}

