/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.repository.config;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.tarantool.core.TarantoolOperations;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentProperty;
import org.springframework.util.Assert;

public class TarantoolRepositoryOperationsMapping {
    private TarantoolOperations defaultOperations;
    private Map<String, TarantoolOperations> byRepository = new HashMap<String, TarantoolOperations>();
    private Map<String, TarantoolOperations> byEntity = new HashMap<String, TarantoolOperations>();

    public TarantoolRepositoryOperationsMapping(TarantoolOperations defaultOperations) {
        this.defaultOperations = defaultOperations;
    }

    private void map(Class<?> repositoryInterface, TarantoolOperations tarantoolOperations) {
        this.byRepository.put(repositoryInterface.getName(), tarantoolOperations);
    }

    private void mapEntity(Class<?> entityClass, TarantoolOperations tarantoolOperations) {
        this.byEntity.put(entityClass.getName(), tarantoolOperations);
    }

    public TarantoolOperations getDefaultOperations() {
        return this.defaultOperations;
    }

    public MappingContext<? extends TarantoolPersistentEntity<?>, TarantoolPersistentProperty> defaultMappingContext() {
        return this.defaultOperations.getConverter().getMappingContext();
    }

    public TarantoolOperations resolve(Class<?> repositoryInterface, Class<?> entityClass) {
        TarantoolOperations result = this.byRepository.get(repositoryInterface.getName());
        if (result == null) {
            result = this.byEntity.get(entityClass.getName());
        }
        if (result == null) {
            result = this.defaultOperations;
        }
        return result;
    }

    public MappingContext<? extends TarantoolPersistentEntity<?>, TarantoolPersistentProperty> getMappingContext() {
        return this.defaultOperations.getConverter().getMappingContext();
    }

    public static class Builder {
        private TarantoolRepositoryOperationsMapping operationsMapping;

        public Builder(TarantoolOperations defaultOperations) {
            Assert.notNull((Object)defaultOperations, (String)"The instance of TarantoolOperations must not be null");
            this.operationsMapping = new TarantoolRepositoryOperationsMapping(defaultOperations);
        }

        public Builder map(Class<?> repositoryInterface, TarantoolOperations tarantoolOperations) {
            this.operationsMapping.map(repositoryInterface, tarantoolOperations);
            return this;
        }

        public Builder mapEntity(Class<?> entityClass, TarantoolOperations tarantoolOperations) {
            this.operationsMapping.mapEntity(entityClass, tarantoolOperations);
            return this;
        }

        public TarantoolRepositoryOperationsMapping build() {
            return this.operationsMapping;
        }
    }
}

