/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.repository.support;

import org.springframework.data.repository.core.support.AbstractEntityInformation;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentProperty;
import org.springframework.data.tarantool.repository.support.TarantoolEntityInformation;

public class MappingTarantoolEntityInformation<T, ID>
extends AbstractEntityInformation<T, ID>
implements TarantoolEntityInformation<T, ID> {
    private final TarantoolPersistentEntity<T> entity;
    private final Class<?> idClass;

    public MappingTarantoolEntityInformation(TarantoolPersistentEntity<T> entity) {
        super(entity.getType());
        this.entity = entity;
        this.idClass = entity.hasIdProperty() ? ((TarantoolPersistentProperty)entity.getIdProperty()).getType() : null;
    }

    public ID getId(T instance) {
        if (this.entity.hasIdProperty()) {
            return (ID)this.entity.getPropertyAccessor(instance).getProperty(this.entity.getIdProperty());
        }
        return null;
    }

    public Class<ID> getIdType() {
        return this.idClass;
    }

    @Override
    public String getSpaceName() {
        return this.entity.getSpaceName();
    }

    @Override
    public String getIdAttribute() {
        return this.entity.hasIdProperty() ? ((TarantoolPersistentProperty)this.entity.getIdProperty()).getFieldName() : null;
    }
}

