/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.repository.support;

import io.tarantool.driver.api.conditions.Conditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.tarantool.core.TarantoolOperations;
import org.springframework.data.tarantool.repository.TarantoolRepository;
import org.springframework.data.tarantool.repository.support.TarantoolEntityInformation;
import org.springframework.util.Assert;

public class SimpleTarantoolRepository<T, ID>
implements TarantoolRepository<T, ID> {
    private final TarantoolOperations tarantoolOperations;
    private final TarantoolEntityInformation<T, ID> entityInformation;

    public SimpleTarantoolRepository(TarantoolEntityInformation<T, ID> entityInformation, TarantoolOperations tarantoolOperations) {
        this.entityInformation = entityInformation;
        this.tarantoolOperations = tarantoolOperations;
    }

    public List<T> findAll() {
        return this.tarantoolOperations.findAll(this.entityInformation.getJavaType());
    }

    public Iterable<T> findAll(Sort sort) {
        return this.findAll();
    }

    public Page<T> findAll(Pageable pageable) {
        throw new UnsupportedOperationException("Count and paging are not supported in the driver yet");
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        throw new UnsupportedOperationException("Search by multiple ids is not supported in the driver yet");
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.tarantoolOperations.findById(id, this.entityInformation.getJavaType()));
    }

    public boolean existsById(ID id) {
        return this.findById(id).isPresent();
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"The entity must not be null");
        return this.tarantoolOperations.save(entity, this.entityInformation.getJavaType());
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null");
        ArrayList<S> result = new ArrayList<S>();
        for (S entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    public long count() {
        throw new UnsupportedOperationException("Count and paging are not supported in the driver yet");
    }

    public void deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null");
        this.tarantoolOperations.removeById(id, this.entityInformation.getJavaType());
    }

    public void delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        this.tarantoolOperations.remove(entity, this.entityInformation.getJavaType());
    }

    public void deleteAllById(Iterable<? extends ID> ids) {
        throw new UnsupportedOperationException("Delete by multiple ids is not supported in the driver yet");
    }

    public void deleteAll(Iterable<? extends T> iterable) {
        throw new UnsupportedOperationException("Delete by multiple ids is not supported in the driver yet");
    }

    public void deleteAll() {
        this.tarantoolOperations.truncate(this.entityInformation.getSpaceName());
    }

    @Override
    public List<T> update(Conditions query, T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null");
        return this.tarantoolOperations.update(query, entity, this.entityInformation.getJavaType());
    }
}

