/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.repository.support;

import java.util.Optional;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.tarantool.core.TarantoolOperations;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentEntity;
import org.springframework.data.tarantool.core.mapping.TarantoolPersistentProperty;
import org.springframework.data.tarantool.core.query.TarantoolQueryLookupStrategy;
import org.springframework.data.tarantool.repository.config.TarantoolRepositoryOperationsMapping;
import org.springframework.data.tarantool.repository.support.MappingTarantoolEntityInformation;
import org.springframework.data.tarantool.repository.support.SimpleTarantoolRepository;
import org.springframework.data.tarantool.repository.support.TarantoolEntityInformation;

public class TarantoolRepositoryFactory
extends RepositoryFactorySupport {
    private final TarantoolRepositoryOperationsMapping operationsMapping;
    private final MappingContext<? extends TarantoolPersistentEntity<?>, TarantoolPersistentProperty> mappingContext;

    public TarantoolRepositoryFactory(TarantoolRepositoryOperationsMapping operationsMapping) {
        this.operationsMapping = operationsMapping;
        this.mappingContext = operationsMapping.defaultMappingContext();
    }

    public <T, ID> TarantoolEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        TarantoolPersistentEntity entity = (TarantoolPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingTarantoolEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        TarantoolOperations tarantoolOperations = this.operationsMapping.resolve(repositoryInformation.getRepositoryInterface(), repositoryInformation.getDomainType());
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        return this.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{entityInformation, tarantoolOperations});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleTarantoolRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new TarantoolQueryLookupStrategy(evaluationContextProvider, this.operationsMapping));
    }
}

