/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.tarantool.repository.support;

import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.tarantool.core.TarantoolOperations;
import org.springframework.data.tarantool.repository.config.TarantoolRepositoryOperationsMapping;
import org.springframework.data.tarantool.repository.support.TarantoolRepositoryFactory;
import org.springframework.util.Assert;

public class TarantoolRepositoryFactoryBean<T extends Repository<S, ID>, S, ID>
extends RepositoryFactoryBeanSupport<T, S, ID> {
    private TarantoolRepositoryOperationsMapping tarantoolOperationsMapping;

    public TarantoolRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setOperations(TarantoolOperations operations) {
        this.setTarantoolOperationsMapping(new TarantoolRepositoryOperationsMapping(operations));
    }

    public void setTarantoolOperationsMapping(TarantoolRepositoryOperationsMapping mapping) {
        this.tarantoolOperationsMapping = mapping;
        this.setMappingContext(this.tarantoolOperationsMapping.getMappingContext());
    }

    public void setMappingContext(MappingContext<?, ?> mappingContext) {
        super.setMappingContext(mappingContext);
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        return new TarantoolRepositoryFactory(this.tarantoolOperationsMapping);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.tarantoolOperationsMapping, (String)"operationsMapping must not be null!");
    }
}

