/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.CartridgeConfigParser;
import org.testcontainers.containers.TarantoolContainer;
import org.testcontainers.containers.TarantoolLogLevel;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.images.builder.dockerfile.DockerfileBuilder;

public class TarantoolCartridgeContainer
extends TarantoolContainer {
    private static final String ROUTER_HOST = "localhost";
    private static final int ROUTER_PORT = 3301;
    private static final String CARTRIDGE_USERNAME = "admin";
    private static final String CARTRIDGE_PASSWORD = "testapp-cluster-cookie";
    private static final String DOCKERFILE_USE_ROOT_PROPERTY = "dockerfileUseRoot";
    private static final int API_PORT = 8081;
    private static final String VSHARD_BOOTSTRAP_COMMAND = "return require('cartridge').admin_bootstrap_vshard()";
    private String routerHost = "localhost";
    private int routerPort = 3301;
    private int apiPort = 8081;
    private String routerUsername = "admin";
    private String routerPassword = "testapp-cluster-cookie";
    private final String instancesFile;
    private final CartridgeConfigParser instanceFileParser;
    private final String topologyConfigurationFile;

    public TarantoolCartridgeContainer(String instancesFile, String topologyConfigurationFile) {
        this(DEFAULT_TARANTOOL_BASE_IMAGE, instancesFile, topologyConfigurationFile);
    }

    public TarantoolCartridgeContainer(String dockerImageName, String instancesFile, String topologyConfigurationFile) {
        super(TarantoolCartridgeContainer.buildImage(dockerImageName));
        if (instancesFile == null || instancesFile.isEmpty()) {
            throw new IllegalArgumentException("Instance file name must not be null or empty");
        }
        this.instancesFile = instancesFile;
        this.instanceFileParser = new CartridgeConfigParser(instancesFile);
        this.topologyConfigurationFile = topologyConfigurationFile;
    }

    public TarantoolCartridgeContainer(String dockerImageName, String buildImageName, String instancesFile, String topologyConfigurationFile) {
        super(TarantoolCartridgeContainer.buildImage(dockerImageName, buildImageName));
        if (instancesFile == null || instancesFile.isEmpty()) {
            throw new IllegalArgumentException("Instance file name must not be null or empty");
        }
        this.instancesFile = instancesFile;
        this.instanceFileParser = new CartridgeConfigParser(instancesFile);
        this.topologyConfigurationFile = topologyConfigurationFile;
    }

    private static Future<String> buildImage(String baseImageName) {
        return (Future)new ImageFromDockerfile().withDockerfileFromBuilder(builder -> TarantoolCartridgeContainer.makeDockerfile(builder, baseImageName));
    }

    private static Future<String> buildImage(String baseImageName, String buildImageName) {
        return (Future)new ImageFromDockerfile(buildImageName, false).withDockerfileFromBuilder(builder -> TarantoolCartridgeContainer.makeDockerfile(builder, baseImageName));
    }

    private static String makeDockerfile(DockerfileBuilder builder, String baseImageName) {
        String useRoot = System.getProperty("useRoot");
        ((DockerfileBuilder)((DockerfileBuilder)((DockerfileBuilder)builder.from(baseImageName)).run(new String[]{"/bin/sh", "-c", "curl -L https://tarantool.io/installer.sh | VER=2.4 /bin/bash -s -- --repo-only && yum -y install cmake make gcc git cartridge-cli && cartridge version"})).workDir("/app")).cmd("cartridge build && cartridge start");
        if (!Boolean.parseBoolean(System.getProperty(DOCKERFILE_USE_ROOT_PROPERTY))) {
            String userGroup = String.format("%s:%s", "tarantool", "tarantool");
            builder.user(userGroup);
        }
        return builder.build();
    }

    protected TarantoolClient getRouterClient() {
        SimpleTarantoolCredentials credentials = new SimpleTarantoolCredentials(this.getUsername(), this.getPassword());
        TarantoolServerAddress address = new TarantoolServerAddress(this.getRouterHost(), this.getRouterPort());
        TarantoolClientConfig config = TarantoolClientConfig.builder().withCredentials((TarantoolCredentials)credentials).build();
        return this.getClient(config, address);
    }

    public String getRouterHost() {
        return this.routerHost;
    }

    public int getRouterPort() {
        return this.getMappedPort(this.routerPort);
    }

    public String getRouterUsername() {
        return this.routerUsername;
    }

    public String getRouterPassword() {
        return this.routerPassword;
    }

    @Override
    public String getHost() {
        return this.getRouterHost();
    }

    @Override
    public int getPort() {
        return this.getRouterPort();
    }

    @Override
    public String getUsername() {
        return this.getRouterUsername();
    }

    @Override
    public String getPassword() {
        return this.getRouterPassword();
    }

    public String getAPIHost() {
        return this.routerHost;
    }

    @Override
    public TarantoolCartridgeContainer withDirectoryBinding(String directoryResourcePath) {
        super.withDirectoryBinding(directoryResourcePath);
        return this;
    }

    public int getAPIPort() {
        return this.getMappedPort(this.apiPort);
    }

    public TarantoolCartridgeContainer withRouterHost(String routerHost) {
        this.checkNotRunning();
        this.routerHost = routerHost;
        return this;
    }

    public TarantoolCartridgeContainer withRouterPort(int routerPort) {
        this.checkNotRunning();
        this.routerPort = routerPort;
        return this;
    }

    public TarantoolCartridgeContainer withAPIPort(int apiPort) {
        this.checkNotRunning();
        this.apiPort = apiPort;
        return this;
    }

    public TarantoolCartridgeContainer withRouterUsername(String routerUsername) {
        this.checkNotRunning();
        this.routerUsername = routerUsername;
        return this;
    }

    public TarantoolCartridgeContainer withRouterPassword(String routerPassword) {
        this.checkNotRunning();
        this.routerPassword = routerPassword;
        return this;
    }

    @Override
    public TarantoolCartridgeContainer withLogLevel(TarantoolLogLevel logLevel) {
        return this;
    }

    @Override
    public TarantoolCartridgeContainer withMemtxMemory(Integer memtxMemory) {
        return this;
    }

    @Override
    protected void configure() {
        this.withFileSystemBind(this.getDirectoryBinding(), this.getInstanceDir(), BindMode.READ_WRITE);
        this.withExposedPorts(this.instanceFileParser.getExposablePorts());
        this.withUsername(this.getRouterUsername());
        this.withPassword(this.getRouterPassword());
        this.withEnv("BOOTSTRAP", "ON");
    }

    @Override
    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.logger().info("Tarantool Cartridge cluster is starting");
    }

    @Override
    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        block4: {
            super.containerIsStarted(containerInfo, reused);
            try {
                this.executeScript(this.topologyConfigurationFile).get();
            }
            catch (Exception e) {
                if (e instanceof ExecutionException && e.getCause() instanceof TimeoutException) break block4;
                this.logger().error("Failed to change the app topology", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            this.executeCommand(VSHARD_BOOTSTRAP_COMMAND, new Object[0]).get();
        }
        catch (Exception e) {
            this.logger().error("Failed to bootstrap vshard cluster", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.logger().info("Tarantool Cartridge cluster is started");
        this.logger().info("Tarantool Cartridge router is listening at {}:{}", (Object)this.getRouterHost(), (Object)this.getRouterPort());
        this.logger().info("Tarantool Cartridge HTTP API is available at {}:{}", (Object)this.getAPIHost(), (Object)this.getAPIPort());
    }

    public TarantoolCartridgeContainer withReuse(boolean reusable) {
        super.withReuse(reusable);
        return this;
    }

    @Override
    public TarantoolCartridgeContainer cleanUpDirectory(String directoryResourcePath) {
        super.cleanUpDirectory(directoryResourcePath);
        return this;
    }
}

