/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import io.tarantool.driver.StandaloneTarantoolClient;
import io.tarantool.driver.TarantoolClientConfig;
import io.tarantool.driver.TarantoolServerAddress;
import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.TarantoolLogLevel;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class TarantoolContainer
extends GenericContainer<TarantoolContainer> {
    public static final String TARANTOOL_SERVER_USER = "tarantool";
    public static final String TARANTOOL_SERVER_GROUP = "tarantool";
    public static final String TARANTOOL_IMAGE = "tarantool/tarantool";
    public static final String DEFAULT_IMAGE_VERSION = "2.x-centos7";
    public static final String DEFAULT_TARANTOOL_BASE_IMAGE = String.format("%s:%s", "tarantool/tarantool", "2.x-centos7");
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 3301;
    private static final String API_USER = "api_user";
    private static final String API_PASSWORD = "secret";
    private static final TarantoolLogLevel LOG_LEVEL = TarantoolLogLevel.VERBOSE;
    private static final Integer MEMTX_MEMORY = 0x8000000;
    private static final String SCRIPT_RESOURCE_DIRECTORY = "";
    private static final String SCRIPT_FILENAME = "server.lua";
    static final String INSTANCE_DIR = "/app";
    private static final String TMP_DIR = "/tmp";
    private String username = "api_user";
    private String password = "secret";
    private String host = "localhost";
    private Integer port = 3301;
    private TarantoolLogLevel logLevel = LOG_LEVEL;
    private Integer memtxMemory = MEMTX_MEMORY;
    private String directoryResourcePath = ((Object)((Object)this)).getClass().getClassLoader().getResource("").getPath();
    private final List<String> cleanupDirectories = new LinkedList<String>();
    private String scriptFileName = "server.lua";
    private final String instanceDir = "/app";
    private final AtomicReference<TarantoolClient> clientHolder = new AtomicReference();

    public TarantoolContainer() {
        this(String.format("%s:%s", TARANTOOL_IMAGE, DEFAULT_IMAGE_VERSION));
    }

    public TarantoolContainer(String dockerImageName) {
        super(dockerImageName);
    }

    public TarantoolContainer(Future<String> image) {
        super(image);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.getMappedPort(this.port);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public TarantoolContainer withUsername(String username) {
        this.checkNotRunning();
        this.username = username;
        return this;
    }

    public TarantoolContainer withPassword(String password) {
        this.checkNotRunning();
        this.password = password;
        return this;
    }

    public TarantoolContainer withLogLevel(TarantoolLogLevel logLevel) {
        this.logLevel = logLevel;
        if (this.isRunning()) {
            try {
                this.executeCommand(logLevel.toCommand(), new Object[0]).get();
            }
            catch (Exception e) {
                this.logger().error(String.format("Failed to set log_level to %s", logLevel.toString()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public TarantoolContainer withMemtxMemory(Integer memtxMemory) {
        if (memtxMemory <= 0) {
            throw new RuntimeException(String.format("The specified memtx_memory value must be >= 0, but was %d", memtxMemory));
        }
        this.memtxMemory = memtxMemory;
        if (this.isRunning()) {
            try {
                this.executeCommand(String.format("box.cfg{memtx_memory=%d}", memtxMemory), new Object[0]).get();
            }
            catch (Exception e) {
                this.logger().error(String.format("Failed to set memtx_memory to %d", memtxMemory), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public TarantoolContainer withDirectoryBinding(String directoryResourcePath) {
        this.checkNotRunning();
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(directoryResourcePath);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("No resource path found for the specified resource %s", directoryResourcePath));
        }
        this.directoryResourcePath = resource.getPath();
        return this;
    }

    public TarantoolContainer cleanUpDirectory(String directoryResourcePath) {
        if (directoryResourcePath == null) {
            throw new IllegalArgumentException(String.format("No resource path found for the specified resource %s", directoryResourcePath));
        }
        this.cleanupDirectories.add(directoryResourcePath);
        return this;
    }

    protected String getDirectoryBinding() {
        return this.directoryResourcePath;
    }

    protected String getInstanceDir() {
        return INSTANCE_DIR;
    }

    public TarantoolContainer withScriptFileName(String scriptFileName) {
        this.checkNotRunning();
        this.scriptFileName = scriptFileName;
        return this;
    }

    protected void checkNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("This option can be changed only before the container is running");
        }
    }

    protected TarantoolClient getClient(TarantoolClientConfig config, TarantoolServerAddress address) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Cannot connect to Tarantool instance in a stopped container");
        }
        if (this.clientHolder.get() == null) {
            this.clientHolder.compareAndSet(null, this.createClient(config, address));
        }
        return this.clientHolder.get();
    }

    private TarantoolClient createClient(TarantoolClientConfig config, TarantoolServerAddress address) {
        return new StandaloneTarantoolClient(config, address);
    }

    protected WaitStrategy tarantoolWaitStrategy() {
        return Wait.forLogMessage((String)".*entering the event loop.*", (int)1);
    }

    protected void configure() {
        this.withFileSystemBind(this.directoryResourcePath, INSTANCE_DIR, BindMode.READ_WRITE);
        this.withExposedPorts(new Integer[]{this.port});
        this.withCommand(new String[]{"tarantool", Paths.get(INSTANCE_DIR, this.scriptFileName).toString().replace('\\', '/')});
        this.waitingFor(this.tarantoolWaitStrategy());
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.logger().info("Tarantool server is starting");
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarted(containerInfo, reused);
        this.withMemtxMemory(this.memtxMemory);
        this.withLogLevel(this.logLevel);
        this.logger().info("Tarantool server is listening at {}:{}", (Object)this.getHost(), (Object)this.getPort());
    }

    protected void containerIsStopping(InspectContainerResponse containerInfo) {
        super.containerIsStopping(containerInfo);
        this.logger().info("Tarantool server is stopping");
        for (String directory : this.cleanupDirectories) {
            Path directoryPath;
            URL directoryResource = ((Object)((Object)this)).getClass().getClassLoader().getResource(this.directoryResourcePath);
            if (directoryResource == null || !Files.isDirectory(directoryPath = Paths.get(directoryResource.getPath(), new String[0]), new LinkOption[0])) continue;
            this.logger().info("Removing all Tarantool data files in directory " + directory);
            try {
                Stream<Path> walk = Files.walk(directoryPath, new FileVisitOption[0]);
                Throwable throwable = null;
                try {
                    walk.sorted(Comparator.reverseOrder()).filter(p -> p.endsWith(".xlog") || p.endsWith(".snap") || p.endsWith(".snap.inprogress")).map(Path::toFile).peek(f -> this.logger().info("Removing Tarantool data file: " + f.getPath())).forEach(File::delete);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (walk == null) continue;
                    if (throwable != null) {
                        try {
                            walk.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    walk.close();
                }
            }
            catch (IOException e) {
                this.logger().error("Failed to remove Tarantool data file", (Throwable)e);
            }
        }
    }

    public CompletableFuture<List<Object>> executeScript(String scriptResourcePath) throws Exception {
        if (!this.isRunning()) {
            throw new IllegalStateException("Cannot execute scripts in stopped container");
        }
        String scriptName = Paths.get(scriptResourcePath, new String[0]).getFileName().toString();
        String containerPath = Paths.get(TMP_DIR, scriptName).toString().replace('\\', '/');
        this.copyFileToContainer(MountableFile.forClasspathResource((String)scriptResourcePath), containerPath);
        return this.executeCommand(String.format("dofile('%s')", containerPath), new Object[0]);
    }

    public CompletableFuture<List<Object>> executeCommand(String command, Object ... arguments) throws Exception {
        if (!this.isRunning()) {
            throw new IllegalStateException("Cannot execute commands in stopped container");
        }
        SimpleTarantoolCredentials credentials = new SimpleTarantoolCredentials(this.getUsername(), this.getPassword());
        TarantoolServerAddress address = new TarantoolServerAddress(this.getHost(), this.getPort());
        TarantoolClientConfig config = TarantoolClientConfig.builder().withCredentials((TarantoolCredentials)credentials).build();
        return this.getClient(config, address).eval(command, Arrays.asList(arguments));
    }
}

