/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.URL;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.CartridgeConfigParser;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.TarantoolContainerClientHelper;
import org.testcontainers.containers.TarantoolContainerOperations;
import org.testcontainers.images.builder.ImageFromDockerfile;

public class TarantoolCartridgeContainer
extends GenericContainer<TarantoolCartridgeContainer>
implements TarantoolContainerOperations<TarantoolCartridgeContainer> {
    private static final String ROUTER_HOST = "localhost";
    private static final int ROUTER_PORT = 3301;
    private static final String CARTRIDGE_USERNAME = "admin";
    private static final String CARTRIDGE_PASSWORD = "testapp-cluster-cookie";
    private static final String DOCKERFILE = "Dockerfile";
    private static final int API_PORT = 8081;
    private static final String VSHARD_BOOTSTRAP_COMMAND = "return require('cartridge').admin_bootstrap_vshard()";
    private static final String SCRIPT_RESOURCE_DIRECTORY = "";
    private static final String INSTANCE_DIR = "/app";
    private static final String ENV_TARANTOOL_VERSION = "TARANTOOL_VERSION";
    private static final String ENV_TARANTOOL_SERVER_USER = "TARANTOOL_SERVER_USER";
    private static final String ENV_TARANTOOL_SERVER_UID = "TARANTOOL_SERVER_UID";
    private static final String ENV_TARANTOOL_SERVER_GROUP = "TARANTOOL_SERVER_GROUP";
    private static final String ENV_TARANTOOL_SERVER_GID = "TARANTOOL_SERVER_GID";
    private static final String ENV_TARANTOOL_WORKDIR = "TARANTOOL_WORKDIR";
    private static final String ENV_TARANTOOL_RUNDIR = "TARANTOOL_RUNDIR";
    private static final String ENV_TARANTOOL_DATADIR = "TARANTOOL_DATADIR";
    private String routerHost = "localhost";
    private int routerPort = 3301;
    private int apiPort = 8081;
    private String routerUsername = "admin";
    private String routerPassword = "testapp-cluster-cookie";
    private String directoryResourcePath = "";
    private String instanceDir = "/app";
    private final String instancesFile;
    private final CartridgeConfigParser instanceFileParser;
    private final String topologyConfigurationFile;
    private final TarantoolContainerClientHelper clientHelper;

    public TarantoolCartridgeContainer(String instancesFile, String topologyConfigurationFile) {
        this(TarantoolCartridgeContainer.withArguments(TarantoolCartridgeContainer.buildImage()), instancesFile, topologyConfigurationFile);
    }

    public TarantoolCartridgeContainer(String dockerFile, String instancesFile, String topologyConfigurationFile) {
        this(TarantoolCartridgeContainer.withArguments(TarantoolCartridgeContainer.buildImage(dockerFile)), instancesFile, topologyConfigurationFile);
    }

    public TarantoolCartridgeContainer(String dockerFile, String buildImageName, String instancesFile, String topologyConfigurationFile) {
        this(TarantoolCartridgeContainer.withArguments(TarantoolCartridgeContainer.buildImage(dockerFile, buildImageName)), instancesFile, topologyConfigurationFile);
    }

    private TarantoolCartridgeContainer(Future<String> image, String instancesFile, String topologyConfigurationFile) {
        super(image);
        if (instancesFile == null || instancesFile.isEmpty()) {
            throw new IllegalArgumentException("Instance file name must not be null or empty");
        }
        this.instancesFile = instancesFile;
        this.instanceFileParser = new CartridgeConfigParser(instancesFile);
        this.topologyConfigurationFile = topologyConfigurationFile;
        this.clientHelper = new TarantoolContainerClientHelper(this);
    }

    private static Future<String> withArguments(ImageFromDockerfile image) {
        return image.withBuildArg(ENV_TARANTOOL_VERSION, System.getenv(ENV_TARANTOOL_VERSION)).withBuildArg(ENV_TARANTOOL_SERVER_USER, System.getenv(ENV_TARANTOOL_SERVER_USER)).withBuildArg(ENV_TARANTOOL_SERVER_UID, System.getenv(ENV_TARANTOOL_SERVER_UID)).withBuildArg(ENV_TARANTOOL_SERVER_GROUP, System.getenv(ENV_TARANTOOL_SERVER_GROUP)).withBuildArg(ENV_TARANTOOL_SERVER_GID, System.getenv(ENV_TARANTOOL_SERVER_GID)).withBuildArg(ENV_TARANTOOL_WORKDIR, System.getenv(ENV_TARANTOOL_WORKDIR)).withBuildArg(ENV_TARANTOOL_RUNDIR, System.getenv(ENV_TARANTOOL_RUNDIR)).withBuildArg(ENV_TARANTOOL_DATADIR, System.getenv(ENV_TARANTOOL_DATADIR));
    }

    private static ImageFromDockerfile buildImage() {
        return TarantoolCartridgeContainer.buildImage(DOCKERFILE);
    }

    private static ImageFromDockerfile buildImage(String dockerFile) {
        return (ImageFromDockerfile)new ImageFromDockerfile().withFileFromClasspath(DOCKERFILE, dockerFile);
    }

    private static ImageFromDockerfile buildImage(String dockerFile, String buildImageName) {
        return (ImageFromDockerfile)new ImageFromDockerfile(buildImageName, false).withFileFromClasspath(DOCKERFILE, dockerFile);
    }

    public String getRouterHost() {
        return this.routerHost;
    }

    public int getRouterPort() {
        return this.getMappedPort(this.routerPort);
    }

    public String getRouterUsername() {
        return this.routerUsername;
    }

    public String getRouterPassword() {
        return this.routerPassword;
    }

    public String getHost() {
        return this.getRouterHost();
    }

    @Override
    public int getPort() {
        return this.getRouterPort();
    }

    @Override
    public String getUsername() {
        return this.getRouterUsername();
    }

    @Override
    public String getPassword() {
        return this.getRouterPassword();
    }

    @Override
    public String getDirectoryBinding() {
        return this.directoryResourcePath;
    }

    public TarantoolCartridgeContainer withInstanceDir(String instanceDir) {
        this.checkNotRunning();
        this.instanceDir = instanceDir;
        return this;
    }

    @Override
    public String getInstanceDir() {
        return this.instanceDir;
    }

    public String getAPIHost() {
        return this.routerHost;
    }

    protected void checkNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("This option can be changed only before the container is running");
        }
    }

    public TarantoolCartridgeContainer withDirectoryBinding(String directoryResourcePath) {
        this.checkNotRunning();
        URL resource = this.getClass().getClassLoader().getResource(directoryResourcePath);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("No resource path found for the specified resource %s", directoryResourcePath));
        }
        this.directoryResourcePath = resource.getPath();
        return this;
    }

    public int getAPIPort() {
        return this.getMappedPort(this.apiPort);
    }

    public TarantoolCartridgeContainer withRouterHost(String routerHost) {
        this.checkNotRunning();
        this.routerHost = routerHost;
        return this;
    }

    public TarantoolCartridgeContainer withRouterPort(int routerPort) {
        this.checkNotRunning();
        this.routerPort = routerPort;
        return this;
    }

    public TarantoolCartridgeContainer withAPIPort(int apiPort) {
        this.checkNotRunning();
        this.apiPort = apiPort;
        return this;
    }

    public TarantoolCartridgeContainer withRouterUsername(String routerUsername) {
        this.checkNotRunning();
        this.routerUsername = routerUsername;
        return this;
    }

    public TarantoolCartridgeContainer withRouterPassword(String routerPassword) {
        this.checkNotRunning();
        this.routerPassword = routerPassword;
        return this;
    }

    protected void configure() {
        this.withFileSystemBind(this.getDirectoryBinding(), this.getInstanceDir(), BindMode.READ_WRITE);
        this.withExposedPorts(this.instanceFileParser.getExposablePorts());
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.logger().info("Tarantool Cartridge cluster is starting");
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        block4: {
            super.containerIsStarted(containerInfo, reused);
            try {
                this.executeScript(this.topologyConfigurationFile).get();
            }
            catch (Exception e) {
                if (e instanceof ExecutionException && e.getCause() instanceof TimeoutException) break block4;
                this.logger().error("Failed to change the app topology", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        try {
            this.executeCommand(VSHARD_BOOTSTRAP_COMMAND, new Object[0]).get();
        }
        catch (Exception e) {
            this.logger().error("Failed to bootstrap vshard cluster", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.logger().info("Tarantool Cartridge cluster is started");
        this.logger().info("Tarantool Cartridge router is listening at {}:{}", (Object)this.getRouterHost(), (Object)this.getRouterPort());
        this.logger().info("Tarantool Cartridge HTTP API is available at {}:{}", (Object)this.getAPIHost(), (Object)this.getAPIPort());
    }

    @Override
    public CompletableFuture<List<?>> executeScript(String scriptResourcePath) throws Exception {
        return this.clientHelper.executeScript(scriptResourcePath);
    }

    @Override
    public CompletableFuture<List<?>> executeCommand(String command, Object ... arguments) throws Exception {
        return this.clientHelper.executeCommand(command, arguments);
    }
}

