/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.URL;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.TarantoolContainerClientHelper;
import org.testcontainers.containers.TarantoolContainerOperations;
import org.testcontainers.containers.TarantoolLogLevel;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class TarantoolContainer
extends GenericContainer<TarantoolContainer>
implements TarantoolContainerOperations<TarantoolContainer> {
    public static final String TARANTOOL_IMAGE = "tarantool/tarantool";
    public static final String DEFAULT_IMAGE_VERSION = "2.x-centos7";
    public static final String DEFAULT_TARANTOOL_BASE_IMAGE = String.format("%s:%s", "tarantool/tarantool", "2.x-centos7");
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 3301;
    private static final String API_USER = "api_user";
    private static final String API_PASSWORD = "secret";
    private static final TarantoolLogLevel LOG_LEVEL = TarantoolLogLevel.VERBOSE;
    private static final Integer MEMTX_MEMORY = 0x8000000;
    private static final String SCRIPT_RESOURCE_DIRECTORY = "";
    private static final String SCRIPT_FILENAME = "server.lua";
    private static final String INSTANCE_DIR = "/app";
    private String username = "api_user";
    private String password = "secret";
    private String host = "localhost";
    private Integer port = 3301;
    private TarantoolLogLevel logLevel = LOG_LEVEL;
    private Integer memtxMemory = MEMTX_MEMORY;
    private String directoryResourcePath = "";
    private String scriptFileName = "server.lua";
    private String instanceDir = "/app";
    private final TarantoolContainerClientHelper clientHelper = new TarantoolContainerClientHelper(this);

    public TarantoolContainer() {
        this(String.format("%s:%s", TARANTOOL_IMAGE, DEFAULT_IMAGE_VERSION));
    }

    public TarantoolContainer(String dockerImageName) {
        super(dockerImageName);
    }

    public TarantoolContainer(Future<String> image) {
        super(image);
    }

    public TarantoolContainer withHost(String host) {
        this.checkNotRunning();
        this.host = host;
        return this;
    }

    public TarantoolContainer withPort(int port) {
        this.checkNotRunning();
        this.port = port;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.getMappedPort(this.port);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public TarantoolContainer withUsername(String username) {
        this.checkNotRunning();
        this.username = username;
        return this;
    }

    public TarantoolContainer withPassword(String password) {
        this.checkNotRunning();
        this.password = password;
        return this;
    }

    public TarantoolContainer withLogLevel(TarantoolLogLevel logLevel) {
        this.logLevel = logLevel;
        if (this.isRunning()) {
            try {
                this.executeCommand(logLevel.toCommand(), new Object[0]).get();
            }
            catch (Exception e) {
                this.logger().error(String.format("Failed to set log_level to %s", logLevel.toString()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public TarantoolContainer withMemtxMemory(Integer memtxMemory) {
        if (memtxMemory <= 0) {
            throw new RuntimeException(String.format("The specified memtx_memory value must be >= 0, but was %d", memtxMemory));
        }
        this.memtxMemory = memtxMemory;
        if (this.isRunning()) {
            try {
                this.executeCommand(String.format("box.cfg{memtx_memory=%d}", memtxMemory), new Object[0]).get();
            }
            catch (Exception e) {
                this.logger().error(String.format("Failed to set memtx_memory to %d", memtxMemory), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public TarantoolContainer withDirectoryBinding(String directoryResourcePath) {
        this.checkNotRunning();
        this.directoryResourcePath = directoryResourcePath;
        return this;
    }

    @Override
    public String getDirectoryBinding() {
        return this.directoryResourcePath;
    }

    public TarantoolContainer withInstanceDir(String instanceDir) {
        this.checkNotRunning();
        this.instanceDir = instanceDir;
        return this;
    }

    @Override
    public String getInstanceDir() {
        return this.instanceDir;
    }

    public TarantoolContainer withScriptFileName(String scriptFileName) {
        this.checkNotRunning();
        this.scriptFileName = scriptFileName;
        return this;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    protected void checkNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("This option can be changed only before the container is running");
        }
    }

    protected void configure() {
        URL sourceDirectory = this.getClass().getClassLoader().getResource(this.getDirectoryBinding());
        if (sourceDirectory == null) {
            throw new IllegalArgumentException(String.format("No resource path found for the specified resource %s", this.getDirectoryBinding()));
        }
        String serverScriptPath = Paths.get(this.getDirectoryBinding(), this.getScriptFileName()).toString();
        URL resource = this.getClass().getClassLoader().getResource(serverScriptPath);
        if (resource == null) {
            throw new RuntimeException(String.format("Server configuration script %s is not found", serverScriptPath));
        }
        this.withFileSystemBind(sourceDirectory.getPath(), this.getInstanceDir(), BindMode.READ_WRITE);
        this.withExposedPorts(new Integer[]{this.port});
        this.withCommand(new String[]{"tarantool", Paths.get(this.getInstanceDir(), this.getScriptFileName()).toString().replace('\\', '/')});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*entering the event loop.*", (int)1));
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.logger().info("Tarantool server is starting");
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarted(containerInfo, reused);
        this.withMemtxMemory(this.memtxMemory);
        this.withLogLevel(this.logLevel);
        this.logger().info("Tarantool server is listening at {}:{}", (Object)this.getHost(), (Object)this.getPort());
    }

    protected void containerIsStopping(InspectContainerResponse containerInfo) {
        super.containerIsStopping(containerInfo);
        this.logger().info("Tarantool server is stopping");
    }

    @Override
    public CompletableFuture<List<?>> executeScript(String scriptResourcePath) throws Exception {
        return this.clientHelper.executeScript(scriptResourcePath);
    }

    @Override
    public CompletableFuture<List<?>> executeCommand(String command, Object ... arguments) throws Exception {
        return this.clientHelper.executeCommand(command, arguments);
    }
}

