/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolClientConfig;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.TarantoolServerAddress;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import io.tarantool.driver.auth.SimpleTarantoolCredentials;
import io.tarantool.driver.auth.TarantoolCredentials;
import io.tarantool.driver.core.ClusterTarantoolTupleClient;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.PathUtils;
import org.testcontainers.containers.TarantoolContainerOperations;
import org.testcontainers.utility.MountableFile;

public final class TarantoolContainerClientHelper {
    private static final String TMP_DIR = "/tmp";
    private final TarantoolContainerOperations<? extends Container<?>> container;
    private final AtomicReference<TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>>> clientHolder = new AtomicReference();

    TarantoolContainerClientHelper(TarantoolContainerOperations<? extends Container<?>> container) {
        this.container = container;
    }

    private TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> createClient(TarantoolClientConfig config, TarantoolServerAddress address) {
        return new ClusterTarantoolTupleClient(config, address);
    }

    public TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> getClient(TarantoolClientConfig config, TarantoolServerAddress address) {
        if (!this.container.isRunning()) {
            throw new IllegalStateException("Cannot connect to Tarantool instance in a stopped container");
        }
        if (this.clientHolder.get() == null) {
            this.clientHolder.compareAndSet(null, this.createClient(config, address));
        }
        return this.clientHolder.get();
    }

    public CompletableFuture<List<?>> executeScript(String scriptResourcePath) {
        if (!this.container.isRunning()) {
            throw new IllegalStateException("Cannot execute scripts in stopped container");
        }
        String scriptName = Paths.get(scriptResourcePath, new String[0]).getFileName().toString();
        String containerPath = PathUtils.normalizePath(Paths.get(TMP_DIR, scriptName));
        this.container.copyFileToContainer(MountableFile.forClasspathResource((String)scriptResourcePath), containerPath);
        return this.executeCommand(String.format("dofile('%s')", containerPath), new Object[0]);
    }

    public CompletableFuture<List<?>> executeCommand(String command, Object ... arguments) {
        if (!this.container.isRunning()) {
            throw new IllegalStateException("Cannot execute commands in stopped container");
        }
        SimpleTarantoolCredentials credentials = new SimpleTarantoolCredentials(this.container.getUsername(), this.container.getPassword());
        TarantoolServerAddress address = new TarantoolServerAddress(this.container.getHost(), this.container.getPort());
        TarantoolClientConfig config = TarantoolClientConfig.builder().withCredentials((TarantoolCredentials)credentials).build();
        return this.getClient(config, address).eval(command, Arrays.asList(arguments));
    }
}

