/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import io.tarantool.driver.api.TarantoolClient;
import io.tarantool.driver.api.TarantoolClientBuilder;
import io.tarantool.driver.api.TarantoolClientFactory;
import io.tarantool.driver.api.TarantoolResult;
import io.tarantool.driver.api.retry.TarantoolRequestRetryPolicies;
import io.tarantool.driver.api.tuple.TarantoolTuple;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.PathUtils;
import org.testcontainers.containers.TarantoolContainerOperations;
import org.testcontainers.utility.MountableFile;

public final class TarantoolContainerClientHelper {
    private static final String TMP_DIR = "/tmp";
    private final TarantoolContainerOperations<? extends Container<?>> container;
    private final AtomicReference<TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>>> clientHolder = new AtomicReference();
    private final TarantoolClientBuilder clientBuilder;

    TarantoolContainerClientHelper(TarantoolContainerOperations<? extends Container<?>> container) {
        this.container = container;
        this.clientBuilder = (TarantoolClientBuilder)TarantoolClientFactory.createClient().withRequestTimeout(5000).withRetryingByNumberOfAttempts(15, TarantoolRequestRetryPolicies.retryNetworkErrors(), b -> b.withDelay(100L));
    }

    TarantoolContainerClientHelper(TarantoolContainerOperations<? extends Container<?>> container, TarantoolClientBuilder clientBuilder) {
        this.container = container;
        this.clientBuilder = clientBuilder;
    }

    private TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> createClient() {
        return this.clientBuilder.withCredentials(this.container.getUsername(), this.container.getPassword()).withAddress(this.container.getHost(), this.container.getPort()).build();
    }

    public TarantoolClient<TarantoolTuple, TarantoolResult<TarantoolTuple>> getClient() {
        if (!this.container.isRunning()) {
            throw new IllegalStateException("Cannot connect to Tarantool instance in a stopped container");
        }
        if (this.clientHolder.get() == null) {
            this.clientHolder.compareAndSet(null, this.createClient());
        }
        return this.clientHolder.get();
    }

    public CompletableFuture<List<?>> executeScript(String scriptResourcePath) {
        if (!this.container.isRunning()) {
            throw new IllegalStateException("Cannot execute scripts in stopped container");
        }
        String scriptName = Paths.get(scriptResourcePath, new String[0]).getFileName().toString();
        String containerPath = PathUtils.normalizePath(Paths.get(TMP_DIR, scriptName));
        this.container.copyFileToContainer(MountableFile.forClasspathResource((String)scriptResourcePath), containerPath);
        return this.executeCommand(String.format("dofile('%s')", containerPath), new Object[0]);
    }

    public CompletableFuture<List<?>> executeCommand(String command, Object ... arguments) {
        if (!this.container.isRunning()) {
            throw new IllegalStateException("Cannot execute commands in stopped container");
        }
        return this.getClient().eval(command, Arrays.asList(arguments));
    }
}

