/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.CartridgeConfigParser;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PathUtils;
import org.testcontainers.containers.SslContext;
import org.testcontainers.containers.TarantoolContainerClientHelper;
import org.testcontainers.containers.TarantoolContainerOperations;
import org.testcontainers.containers.exceptions.CartridgeTopologyException;
import org.testcontainers.images.builder.ImageFromDockerfile;
import org.testcontainers.shaded.org.apache.commons.lang3.ArrayUtils;

public class TarantoolCartridgeContainer
extends GenericContainer<TarantoolCartridgeContainer>
implements TarantoolContainerOperations<TarantoolCartridgeContainer> {
    private static final String ROUTER_HOST = "localhost";
    private static final int ROUTER_PORT = 3301;
    private static final String CARTRIDGE_USERNAME = "admin";
    private static final String CARTRIDGE_PASSWORD = "testapp-cluster-cookie";
    private static final String DOCKERFILE = "Dockerfile";
    private static final int API_PORT = 8081;
    private static final String VSHARD_BOOTSTRAP_COMMAND = "return require('cartridge').admin_bootstrap_vshard()";
    private static final String SCRIPT_RESOURCE_DIRECTORY = "";
    private static final String INSTANCE_DIR = "/app";
    private static final String ENV_TARANTOOL_VERSION = "TARANTOOL_VERSION";
    private static final String ENV_TARANTOOL_SERVER_USER = "TARANTOOL_SERVER_USER";
    private static final String ENV_TARANTOOL_SERVER_UID = "TARANTOOL_SERVER_UID";
    private static final String ENV_TARANTOOL_SERVER_GROUP = "TARANTOOL_SERVER_GROUP";
    private static final String ENV_TARANTOOL_SERVER_GID = "TARANTOOL_SERVER_GID";
    private static final String ENV_TARANTOOL_WORKDIR = "TARANTOOL_WORKDIR";
    private static final String ENV_TARANTOOL_RUNDIR = "TARANTOOL_RUNDIR";
    private static final String ENV_TARANTOOL_DATADIR = "TARANTOOL_DATADIR";
    private static final String ENV_TARANTOOL_INSTANCES_FILE = "TARANTOOL_INSTANCES_FILE";
    private final CartridgeConfigParser instanceFileParser;
    private final TarantoolContainerClientHelper clientHelper;
    private final String TARANTOOL_RUN_DIR;
    private boolean useFixedPorts = false;
    private String routerHost = "localhost";
    private int routerPort = 3301;
    private int apiPort = 8081;
    private String routerUsername = "admin";
    private String routerPassword = "testapp-cluster-cookie";
    private String directoryResourcePath = "";
    private String instanceDir = "/app";
    private String topologyConfigurationFile;
    private SslContext sslContext;

    public TarantoolCartridgeContainer(String instancesFile, String topologyConfigurationFile) {
        this(DOCKERFILE, instancesFile, topologyConfigurationFile);
    }

    public TarantoolCartridgeContainer(String instancesFile, String topologyConfigurationFile, Map<String, String> buildArgs) {
        this(DOCKERFILE, SCRIPT_RESOURCE_DIRECTORY, instancesFile, topologyConfigurationFile, buildArgs);
    }

    public TarantoolCartridgeContainer(String dockerFile, String instancesFile, String topologyConfigurationFile) {
        this(dockerFile, SCRIPT_RESOURCE_DIRECTORY, instancesFile, topologyConfigurationFile);
    }

    public TarantoolCartridgeContainer(String dockerFile, String buildImageName, String instancesFile, String topologyConfigurationFile) {
        this(dockerFile, buildImageName, instancesFile, topologyConfigurationFile, Collections.emptyMap());
    }

    public TarantoolCartridgeContainer(String dockerFile, String buildImageName, String instancesFile, String topologyConfigurationFile, Map<String, String> buildArgs) {
        this(TarantoolCartridgeContainer.buildImage(dockerFile, buildImageName, buildArgs), instancesFile, topologyConfigurationFile, buildArgs);
    }

    private TarantoolCartridgeContainer(ImageFromDockerfile image, String instancesFile, String topologyConfigurationFile, Map<String, String> buildArgs) {
        super((Future)TarantoolCartridgeContainer.withBuildArgs(image, buildArgs));
        this.TARANTOOL_RUN_DIR = TarantoolCartridgeContainer.mergeBuildArguments(buildArgs).getOrDefault(ENV_TARANTOOL_RUNDIR, "/tmp/run");
        if (instancesFile == null || instancesFile.isEmpty()) {
            throw new IllegalArgumentException("Instance file name must not be null or empty");
        }
        if (topologyConfigurationFile == null || topologyConfigurationFile.isEmpty()) {
            throw new IllegalArgumentException("Topology configuration file must not be null or empty");
        }
        this.topologyConfigurationFile = topologyConfigurationFile;
        this.instanceFileParser = new CartridgeConfigParser(instancesFile);
        this.clientHelper = new TarantoolContainerClientHelper(this);
    }

    private static ImageFromDockerfile withBuildArgs(ImageFromDockerfile image, Map<String, String> buildArgs) {
        Map<String, String> args = TarantoolCartridgeContainer.mergeBuildArguments(buildArgs);
        if (!args.isEmpty()) {
            image.withBuildArgs(args);
        }
        return image;
    }

    public TarantoolCartridgeContainer withFixedExposedPort(int hostPort, int containerPort) {
        super.addFixedExposedPort(hostPort, containerPort);
        return this;
    }

    public TarantoolCartridgeContainer withExposedPort(Integer port) {
        super.addExposedPort(port);
        return this;
    }

    private static Map<String, String> mergeBuildArguments(Map<String, String> buildArgs) {
        HashMap<String, String> args = new HashMap<String, String>(buildArgs);
        for (String envVariable : Arrays.asList(ENV_TARANTOOL_VERSION, ENV_TARANTOOL_SERVER_USER, ENV_TARANTOOL_SERVER_UID, ENV_TARANTOOL_SERVER_GROUP, ENV_TARANTOOL_SERVER_GID, ENV_TARANTOOL_WORKDIR, ENV_TARANTOOL_RUNDIR, ENV_TARANTOOL_DATADIR, ENV_TARANTOOL_INSTANCES_FILE)) {
            String variableValue = System.getenv(envVariable);
            if (variableValue == null || args.containsKey(envVariable)) continue;
            args.put(envVariable, variableValue);
        }
        return args;
    }

    private static ImageFromDockerfile buildImage(String dockerFile, String buildImageName, Map<String, String> buildArgs) {
        ImageFromDockerfile image = buildImageName != null && !buildImageName.isEmpty() ? new ImageFromDockerfile(buildImageName, false) : new ImageFromDockerfile();
        return (ImageFromDockerfile)((ImageFromDockerfile)image.withFileFromClasspath(DOCKERFILE, dockerFile)).withFileFromClasspath("cartridge", buildArgs.get("CARTRIDGE_SRC_DIR") == null ? "cartridge" : buildArgs.get("CARTRIDGE_SRC_DIR"));
    }

    public String getRouterHost() {
        return this.routerHost;
    }

    public int getRouterPort() {
        if (this.useFixedPorts) {
            return this.routerPort;
        }
        return this.getMappedPort(this.routerPort);
    }

    public String getRouterUsername() {
        return this.routerUsername;
    }

    public String getRouterPassword() {
        return this.routerPassword;
    }

    public String getHost() {
        return this.getRouterHost();
    }

    @Override
    public int getPort() {
        return this.getRouterPort();
    }

    @Override
    public String getUsername() {
        return this.getRouterUsername();
    }

    @Override
    public String getPassword() {
        return this.getRouterPassword();
    }

    @Override
    public String getDirectoryBinding() {
        return this.directoryResourcePath;
    }

    public TarantoolCartridgeContainer withInstanceDir(String instanceDir) {
        this.checkNotRunning();
        this.instanceDir = instanceDir;
        return this;
    }

    @Override
    public String getInstanceDir() {
        return this.instanceDir;
    }

    @Override
    public int getInternalPort() {
        return this.routerPort;
    }

    public String getAPIHost() {
        return this.routerHost;
    }

    protected void checkNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("This option can be changed only before the container is running");
        }
    }

    public TarantoolCartridgeContainer withDirectoryBinding(String directoryResourcePath) {
        this.checkNotRunning();
        URL resource = this.getClass().getClassLoader().getResource(directoryResourcePath);
        if (resource == null) {
            throw new IllegalArgumentException(String.format("No resource path found for the specified resource %s", directoryResourcePath));
        }
        this.directoryResourcePath = PathUtils.normalizePath(resource.getPath());
        return this;
    }

    public int getAPIPort() {
        if (this.useFixedPorts) {
            return this.apiPort;
        }
        return this.getMappedPort(this.apiPort);
    }

    public TarantoolCartridgeContainer withUseFixedPorts(boolean useFixedPorts) {
        this.useFixedPorts = useFixedPorts;
        return this;
    }

    public TarantoolCartridgeContainer withRouterHost(String routerHost) {
        this.checkNotRunning();
        this.routerHost = routerHost;
        return this;
    }

    public TarantoolCartridgeContainer withRouterPort(int routerPort) {
        this.checkNotRunning();
        this.routerPort = routerPort;
        return this;
    }

    public TarantoolCartridgeContainer withAPIPort(int apiPort) {
        this.checkNotRunning();
        this.apiPort = apiPort;
        return this;
    }

    public TarantoolCartridgeContainer withRouterUsername(String routerUsername) {
        this.checkNotRunning();
        this.routerUsername = routerUsername;
        return this;
    }

    public TarantoolCartridgeContainer withRouterPassword(String routerPassword) {
        this.checkNotRunning();
        this.routerPassword = routerPassword;
        return this;
    }

    protected void configure() {
        if (!this.getDirectoryBinding().isEmpty()) {
            this.withFileSystemBind(this.getDirectoryBinding(), this.getInstanceDir(), BindMode.READ_WRITE);
        }
        if (this.useFixedPorts) {
            for (Integer port : this.instanceFileParser.getExposablePorts()) {
                this.addFixedExposedPort(port, port);
            }
        } else {
            this.addExposedPorts(ArrayUtils.toPrimitive((Integer[])this.instanceFileParser.getExposablePorts()));
        }
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.logger().info("Tarantool Cartridge cluster is starting");
    }

    private boolean setupTopology() {
        block9: {
            String fileType = this.topologyConfigurationFile.substring(this.topologyConfigurationFile.lastIndexOf(46) + 1);
            if (fileType.equals("yml")) {
                String replicasetsFileName = this.topologyConfigurationFile.substring(this.topologyConfigurationFile.lastIndexOf(47) + 1);
                try {
                    Container.ExecResult result = this.execInContainer(new String[]{"cartridge", "replicasets", "--run-dir=" + this.TARANTOOL_RUN_DIR, "--file=" + replicasetsFileName, "setup", "--bootstrap-vshard"});
                    if (result.getExitCode() != 0) {
                        throw new CartridgeTopologyException("Failed to change the app topology via cartridge CLI: " + result.getStdout());
                    }
                    break block9;
                }
                catch (Exception e) {
                    throw new CartridgeTopologyException(e);
                }
            }
            try {
                List res = (List)this.executeScriptDecoded(this.topologyConfigurationFile);
                if (res.size() >= 2 && res.get(1) != null && res.get(1) instanceof Map) {
                    HashMap error = (HashMap)res.get(1);
                    return error.get("str").toString().contains("collision with another server");
                }
            }
            catch (Exception e) {
                if (e instanceof ExecutionException) {
                    if (e.getCause() instanceof TimeoutException) {
                        return true;
                    }
                }
                throw new CartridgeTopologyException(e);
            }
        }
        return true;
    }

    private void retryingSetupTopology() {
        if (!this.setupTopology()) {
            try {
                this.logger().info("Retrying setup topology in 10 seconds");
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!this.setupTopology()) {
                throw new CartridgeTopologyException("Failed to change the app topology after retry");
            }
        }
    }

    private void bootstrapVshard() {
        try {
            this.executeCommand(VSHARD_BOOTSTRAP_COMMAND);
        }
        catch (Exception e) {
            this.logger().error("Failed to bootstrap vshard cluster", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarted(containerInfo, reused);
        this.waitUntilRouterIsUp(60);
        this.retryingSetupTopology();
        this.waitUntilCartridgeIsHealthy(10);
        this.bootstrapVshard();
        this.logger().info("Tarantool Cartridge cluster is started");
        this.logger().info("Tarantool Cartridge router is listening at {}:{}", (Object)this.getRouterHost(), (Object)this.getRouterPort());
        this.logger().info("Tarantool Cartridge HTTP API is available at {}:{}", (Object)this.getAPIHost(), (Object)this.getAPIPort());
    }

    private void waitUntilRouterIsUp(int secondsToWait) {
        this.waitUntilTrue(secondsToWait, this::routerIsUp);
    }

    private void waitUntilCartridgeIsHealthy(int secondsToWait) {
        this.waitUntilTrue(secondsToWait, this::isCartridgeHealthy);
    }

    private void waitUntilTrue(int secondsToWait, Supplier<Boolean> waitFunc) {
        int secondsPassed = 0;
        boolean result = waitFunc.get();
        while (!result && secondsPassed < secondsToWait) {
            result = waitFunc.get();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        if (!result) {
            throw new RuntimeException("Failed to change the app topology after retry");
        }
    }

    private boolean routerIsUp() {
        String healthyCmd = " local cartridge = package.loaded['cartridge'] return cartridge ~= nil";
        try {
            List result = (List)this.executeCommandDecoded(healthyCmd);
            return result.get(0).getClass() == Boolean.class && (Boolean)result.get(0) != false;
        }
        catch (Exception e) {
            this.logger().warn("Error while waiting for router instance to be up: " + e.getMessage());
            return false;
        }
    }

    private boolean isCartridgeHealthy() {
        String healthyCmd = " local cartridge = package.loaded['cartridge'] return cartridge ~= nil and cartridge.is_healthy()";
        try {
            List result = (List)this.executeCommandDecoded(healthyCmd);
            return result.get(0).getClass() == Boolean.class && (Boolean)result.get(0) != false;
        }
        catch (Exception e) {
            this.logger().warn("Error while waiting for cartridge healthy state: " + e.getMessage());
            return false;
        }
    }

    @Override
    public Container.ExecResult executeScript(String scriptResourcePath) throws Exception {
        return this.clientHelper.executeScript(scriptResourcePath, this.sslContext);
    }

    @Override
    public <T> T executeScriptDecoded(String scriptResourcePath) throws Exception {
        return this.clientHelper.executeScriptDecoded(scriptResourcePath, this.sslContext);
    }

    @Override
    public Container.ExecResult executeCommand(String command) throws Exception {
        return this.clientHelper.executeCommand(command, this.sslContext);
    }

    @Override
    public <T> T executeCommandDecoded(String command) throws Exception {
        return this.clientHelper.executeCommandDecoded(command, this.sslContext);
    }
}

