/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.command.BuildImageResultCallback;
import com.github.dockerjava.api.model.Image;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.TarantoolImageParams;

class TarantoolContainerImageHelper {
    private TarantoolContainerImageHelper() {
    }

    static String getImage(TarantoolImageParams imageParams) {
        String tag = imageParams.getTag();
        if (tag == null || tag.isEmpty()) {
            throw new IllegalArgumentException("Image tag is null or empty!");
        }
        if (!TarantoolContainerImageHelper.hasImage(tag)) {
            TarantoolContainerImageHelper.buildImage(imageParams);
        }
        return tag;
    }

    private static void buildImage(TarantoolImageParams imageParams) {
        BuildImageCmd buildImageCmd = TarantoolContainerImageHelper.getDockerClient().buildImageCmd(imageParams.getDockerfile());
        Map<String, String> buildArgs = imageParams.getBuildArgs();
        for (Map.Entry<String, String> entry : buildArgs.entrySet()) {
            buildImageCmd.withBuildArg(entry.getKey(), entry.getValue());
        }
        ((BuildImageResultCallback)buildImageCmd.withTags(new HashSet<String>(Collections.singletonList(imageParams.getTag()))).exec((ResultCallback)new BuildImageResultCallback())).awaitImageId();
    }

    private static boolean hasImage(String tag) {
        List images = (List)TarantoolContainerImageHelper.getDockerClient().listImagesCmd().exec();
        return images.stream().map(Image::getRepoTags).map(Arrays::asList).flatMap(Collection::stream).anyMatch(repoTag -> repoTag.equals(tag));
    }

    private static DockerClient getDockerClient() {
        return DockerClientFactory.instance().client();
    }
}

