/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import com.github.dockerjava.api.command.InspectContainerResponse;
import java.net.URL;
import java.nio.file.Paths;
import java.util.concurrent.Future;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.PathUtils;
import org.testcontainers.containers.SslContext;
import org.testcontainers.containers.TarantoolContainerClientHelper;
import org.testcontainers.containers.TarantoolContainerImageHelper;
import org.testcontainers.containers.TarantoolContainerOperations;
import org.testcontainers.containers.TarantoolImageParams;
import org.testcontainers.containers.TarantoolLogLevel;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class TarantoolContainer
extends GenericContainer<TarantoolContainer>
implements TarantoolContainerOperations<TarantoolContainer> {
    public static final String TARANTOOL_IMAGE = "tarantool/tarantool";
    public static final String DEFAULT_IMAGE_VERSION = "2.10.5";
    public static final String DEFAULT_TARANTOOL_BASE_IMAGE = String.format("%s:%s-centos7", "tarantool/tarantool", "2.10.5");
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 3301;
    private static final String API_USER = "api_user";
    private static final String API_PASSWORD = "secret";
    private static final TarantoolLogLevel LOG_LEVEL = TarantoolLogLevel.VERBOSE;
    private static final Integer MEMTX_MEMORY = 0x8000000;
    private static final String SCRIPT_RESOURCE_DIRECTORY = "";
    private static final String SCRIPT_FILENAME = "server.lua";
    private static final String INSTANCE_DIR = "/app";
    private String username = "api_user";
    private String password = "secret";
    private String host = "localhost";
    private Integer port = 3301;
    private TarantoolLogLevel logLevel = LOG_LEVEL;
    private Integer memtxMemory = MEMTX_MEMORY;
    private String directoryResourcePath = "";
    private String scriptFileName = "server.lua";
    private String instanceDir = "/app";
    private boolean useFixedPorts = false;
    private SslContext sslContext;
    private final TarantoolContainerClientHelper clientHelper = new TarantoolContainerClientHelper(this);

    public TarantoolContainer() {
        this(DEFAULT_TARANTOOL_BASE_IMAGE);
        this.setImageNameFromEnv();
    }

    public TarantoolContainer(String dockerImageName) {
        super(dockerImageName);
    }

    public TarantoolContainer(TarantoolImageParams tarantoolImageParams) {
        super(TarantoolContainerImageHelper.getImage(tarantoolImageParams));
    }

    public TarantoolContainer(Future<String> image) {
        super(image);
    }

    public TarantoolContainer withUseFixedPorts(boolean useFixedPorts) {
        this.useFixedPorts = useFixedPorts;
        return this;
    }

    public TarantoolContainer withHost(String host) {
        this.checkNotRunning();
        this.host = host;
        return this;
    }

    public TarantoolContainer withPort(int port) {
        this.checkNotRunning();
        this.port = port;
        return this;
    }

    public TarantoolContainer withFixedExposedPort(int hostPort, int containerPort) {
        super.addFixedExposedPort(hostPort, containerPort);
        return this;
    }

    public TarantoolContainer withExposedPort(Integer port) {
        super.addExposedPort(port);
        return this;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public int getPort() {
        return this.getMappedPort(this.port);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public TarantoolContainer withUsername(String username) {
        this.checkNotRunning();
        this.username = username;
        return this;
    }

    public TarantoolContainer withPassword(String password) {
        this.checkNotRunning();
        this.password = password;
        return this;
    }

    public TarantoolContainer withSslContext(SslContext sslContext) {
        this.checkNotRunning();
        this.sslContext = sslContext;
        return this;
    }

    public TarantoolContainer withLogLevel(TarantoolLogLevel logLevel) {
        this.logLevel = logLevel;
        if (this.isRunning()) {
            try {
                this.executeCommand(logLevel.toCommand());
            }
            catch (Exception e) {
                this.logger().error(String.format("Failed to set log_level to %s", logLevel.toString()), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public TarantoolContainer withMemtxMemory(Integer memtxMemory) {
        if (memtxMemory <= 0) {
            throw new RuntimeException(String.format("The specified memtx_memory value must be >= 0, but was %d", memtxMemory));
        }
        this.memtxMemory = memtxMemory;
        if (this.isRunning()) {
            try {
                this.executeCommand(String.format("box.cfg{memtx_memory=%d}", memtxMemory));
            }
            catch (Exception e) {
                this.logger().error(String.format("Failed to set memtx_memory to %d", memtxMemory), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public TarantoolContainer withDirectoryBinding(String directoryResourcePath) {
        this.checkNotRunning();
        this.directoryResourcePath = PathUtils.normalizePath(directoryResourcePath);
        return this;
    }

    @Override
    public String getDirectoryBinding() {
        return this.directoryResourcePath;
    }

    public TarantoolContainer withInstanceDir(String instanceDir) {
        this.checkNotRunning();
        this.instanceDir = instanceDir;
        return this;
    }

    @Override
    public String getInstanceDir() {
        return this.instanceDir;
    }

    @Override
    public int getInternalPort() {
        return this.port;
    }

    public TarantoolContainer withScriptFileName(String scriptFileName) {
        this.checkNotRunning();
        this.scriptFileName = scriptFileName;
        return this;
    }

    public String getScriptFileName() {
        return this.scriptFileName;
    }

    protected void checkNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("This option can be changed only before the container is running");
        }
    }

    private void checkServerScriptExists() {
        String serverScriptPath = Paths.get(this.getDirectoryBinding(), this.getScriptFileName()).toString();
        URL resource = this.getClass().getClassLoader().getResource(serverScriptPath);
        if (resource == null) {
            throw new RuntimeException(String.format("Server configuration script %s is not found", serverScriptPath));
        }
    }

    protected void configure() {
        this.checkServerScriptExists();
        URL sourceDirectory = this.getClass().getClassLoader().getResource(this.getDirectoryBinding());
        if (sourceDirectory == null) {
            throw new IllegalArgumentException(String.format("No resource path found for the specified resource %s", this.getDirectoryBinding()));
        }
        String sourceDirectoryPath = PathUtils.normalizePath(sourceDirectory.getPath());
        if (!sourceDirectoryPath.isEmpty()) {
            this.withFileSystemBind(sourceDirectoryPath, this.getInstanceDir(), BindMode.READ_WRITE);
        }
        if (this.useFixedPorts) {
            this.addFixedExposedPort(this.port, this.port);
        } else {
            this.addExposedPorts(new int[]{this.port});
        }
        this.withCommand(new String[]{"tarantool", PathUtils.normalizePath(Paths.get(this.getInstanceDir(), this.getScriptFileName()))});
        this.waitingFor((WaitStrategy)Wait.forLogMessage((String)".*entering the event loop.*", (int)1));
    }

    protected void containerIsStarting(InspectContainerResponse containerInfo) {
        this.logger().info("Tarantool server is starting");
    }

    protected void containerIsStarted(InspectContainerResponse containerInfo, boolean reused) {
        super.containerIsStarted(containerInfo, reused);
        this.withMemtxMemory(this.memtxMemory);
        this.withLogLevel(this.logLevel);
        this.logger().info("Tarantool server is listening at {}:{}", (Object)this.getHost(), (Object)this.getPort());
    }

    protected void containerIsStopping(InspectContainerResponse containerInfo) {
        super.containerIsStopping(containerInfo);
        this.logger().info("Tarantool server is stopping");
    }

    @Override
    public Container.ExecResult executeScript(String scriptResourcePath) throws Exception {
        return this.clientHelper.executeScript(scriptResourcePath, this.sslContext);
    }

    @Override
    public <T> T executeScriptDecoded(String scriptResourcePath) throws Exception {
        return this.clientHelper.executeScriptDecoded(scriptResourcePath, this.sslContext);
    }

    @Override
    public Container.ExecResult executeCommand(String command) throws Exception {
        return this.clientHelper.executeCommand(command, this.sslContext);
    }

    @Override
    public <T> T executeCommandDecoded(String command) throws Exception {
        return this.clientHelper.executeCommandDecoded(command, this.sslContext);
    }

    private void setImageNameFromEnv() {
        String version = System.getenv("TARANTOOL_VERSION");
        if (version != null && !version.trim().isEmpty()) {
            this.setDockerImageName(String.format("%s:%s-centos7", TARANTOOL_IMAGE, version));
        }
    }
}

