/*
 * Decompiled with CFR 0.152.
 */
package org.testcontainers.containers;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.concurrent.ExecutionException;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.PathUtils;
import org.testcontainers.containers.SslContext;
import org.testcontainers.containers.TarantoolContainerOperations;
import org.testcontainers.utility.MountableFile;
import org.yaml.snakeyaml.Yaml;

public final class TarantoolContainerClientHelper {
    private static final String TMP_DIR = "/tmp";
    private static final Yaml yaml = new Yaml();
    private final TarantoolContainerOperations<? extends Container<?>> container;
    private final String EXECUTE_SCRIPT_ERROR_TEMPLATE = "Executed script %s with exit code %d, stderr: \"%s\", stdout: \"%s\"";
    private static final String EXECUTE_COMMAND_ERROR_TEMPLATE = "Executed command \"%s\" with exit code %d, stderr: \"%s\", stdout: \"%s\"";
    private static final String MTLS_COMMAND_TEMPLATE = "echo \"     print(require('yaml').encode(         {require('net.box').connect(             { uri='%s:%d', params = { transport='ssl', ssl_key_file = '%s', ssl_cert_file = '%s' }},              { user = '%s', password = '%s' }             ):eval('%s')})         );     os.exit(); \" | tarantool";
    private static final String SSL_COMMAND_TEMPLATE = "echo \"     print(require('yaml').encode(         {require('net.box').connect(             { uri='%s:%d', params = { transport='ssl' }},              { user = '%s', password = '%s' }             ):eval('%s')})         );     os.exit(); \" | tarantool";
    private static final String COMMAND_TEMPLATE = "echo \"     print(require('yaml').encode(         {require('net.box').connect(             '%s:%d',              { user = '%s', password = '%s' }             ):eval('%s')})         );     os.exit(); \" | tarantool";

    TarantoolContainerClientHelper(TarantoolContainerOperations<? extends Container<?>> container) {
        this.container = container;
    }

    public Container.ExecResult executeScript(String scriptResourcePath, SslContext sslContext) throws IOException, InterruptedException {
        if (!this.container.isRunning()) {
            throw new IllegalStateException("Cannot execute scripts in stopped container");
        }
        String scriptName = Paths.get(scriptResourcePath, new String[0]).getFileName().toString();
        String containerPath = PathUtils.normalizePath(Paths.get(TMP_DIR, scriptName));
        this.container.copyFileToContainer(MountableFile.forClasspathResource((String)scriptResourcePath), containerPath);
        return this.executeCommand(String.format("return dofile('%s')", containerPath), sslContext);
    }

    public <T> T executeScriptDecoded(String scriptResourcePath, SslContext sslContext) throws IOException, InterruptedException, ExecutionException {
        Container.ExecResult result = this.executeScript(scriptResourcePath, sslContext);
        if (result.getExitCode() != 0) {
            if (result.getExitCode() == 3 || result.getExitCode() == 1) {
                throw new ExecutionException(String.format("Executed script %s with exit code %d, stderr: \"%s\", stdout: \"%s\"", scriptResourcePath, result.getExitCode(), result.getStderr(), result.getStdout()), new Throwable());
            }
            throw new IllegalStateException(String.format("Executed script %s with exit code %d, stderr: \"%s\", stdout: \"%s\"", scriptResourcePath, result.getExitCode(), result.getStderr(), result.getStdout()));
        }
        return (T)yaml.load(result.getStdout());
    }

    public Container.ExecResult executeCommand(String command, SslContext sslContext) throws IOException, InterruptedException {
        if (!this.container.isRunning()) {
            throw new IllegalStateException("Cannot execute commands in stopped container");
        }
        command = command.replace("\"", "\\\"");
        command = command.replace("'", "\\'");
        String bashCommand = sslContext == null ? String.format(COMMAND_TEMPLATE, this.container.getHost(), this.container.getInternalPort(), this.container.getUsername(), this.container.getPassword(), command) : (sslContext.getKeyFile() != null && sslContext.getCertFile() != null ? String.format(MTLS_COMMAND_TEMPLATE, this.container.getHost(), this.container.getInternalPort(), sslContext.getKeyFile(), sslContext.getCertFile(), this.container.getUsername(), this.container.getPassword(), command) : String.format(SSL_COMMAND_TEMPLATE, this.container.getHost(), this.container.getInternalPort(), this.container.getUsername(), this.container.getPassword(), command));
        return this.container.execInContainer(new String[]{"sh", "-c", bashCommand});
    }

    public <T> T executeCommandDecoded(String command, SslContext sslContext) throws IOException, InterruptedException {
        Container.ExecResult result = this.executeCommand(command, sslContext);
        if (result.getExitCode() != 0) {
            throw new IllegalStateException(String.format(EXECUTE_COMMAND_ERROR_TEMPLATE, command, result.getExitCode(), result.getStderr(), result.getStdout()));
        }
        return (T)yaml.load(result.getStdout());
    }
}

