/*
 * Copyright (C) 2022 Temporal Technologies, Inc. All Rights Reserved.
 *
 * Copyright (C) 2012-2016 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Modifications copyright (C) 2017 Uber Technologies, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this material except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.temporal.activity

import kotlin.reflect.javaType
import kotlin.reflect.typeOf

/**
 * Extracts Heartbeat details from the last failed attempt.
 *
 * @param T type of the Heartbeat details
 * @see ActivityExecutionContext.getHeartbeatDetails
 */
@OptIn(ExperimentalStdlibApi::class)
inline fun <reified T> ActivityExecutionContext.getHeartbeatDetailsOrNull(): T? {
  return getHeartbeatDetails(T::class.java, typeOf<T>().javaType).orElse(null)
}
