/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.async;

import io.temporal.internal.async.spi.MethodReferenceDisassemblyService;
import io.temporal.workflow.Functions;
import java.lang.reflect.Field;
import kotlin.Metadata;
import kotlin.jvm.internal.CallableReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Lambda;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lio/temporal/internal/async/KotlinMethodReferenceDisassemblyService;", "Lio/temporal/internal/async/spi/MethodReferenceDisassemblyService;", "()V", "getLanguageName", "", "getMethodReferenceTarget", "", "methodReference", "unwrapCallableReference", "callableReference", "Lkotlin/jvm/internal/CallableReference;", "unwrapIfCallableReference", "unwrapTemporalFunctionalInterfaceInKotlin", "temporalFunction", "Lio/temporal/workflow/Functions$TemporalFunctionalInterfaceMarker;", "temporal-kotlin"})
public final class KotlinMethodReferenceDisassemblyService
implements MethodReferenceDisassemblyService {
    @Nullable
    public Object getMethodReferenceTarget(@NotNull Object methodReference) {
        Intrinsics.checkNotNullParameter((Object)methodReference, (String)"methodReference");
        Object object = methodReference;
        return object instanceof Functions.TemporalFunctionalInterfaceMarker ? this.unwrapTemporalFunctionalInterfaceInKotlin((Functions.TemporalFunctionalInterfaceMarker)methodReference) : this.unwrapIfCallableReference(methodReference);
    }

    private final Object unwrapIfCallableReference(Object callableReference) {
        Object object = callableReference;
        return object instanceof CallableReference ? this.unwrapCallableReference((CallableReference)callableReference) : (object instanceof Lambda ? null : null);
    }

    private final Object unwrapCallableReference(CallableReference callableReference) {
        Object object = callableReference.getBoundReceiver();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"callableReference.boundReceiver");
        return object;
    }

    private final Object unwrapTemporalFunctionalInterfaceInKotlin(Functions.TemporalFunctionalInterfaceMarker temporalFunction) {
        Field proxiedField;
        Field[] declaredFields = temporalFunction.getClass().getDeclaredFields();
        if (declaredFields.length != 1) {
            return null;
        }
        Field field = proxiedField = declaredFields[0];
        Intrinsics.checkNotNullExpressionValue((Object)field, (String)"proxiedField");
        field.setAccessible(true);
        Object proxiedValue = proxiedField.get(temporalFunction);
        if (Intrinsics.areEqual((Object)"function", (Object)proxiedField.getName())) {
            Object object = proxiedValue;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proxiedValue");
            return this.unwrapIfCallableReference(object);
        }
        return proxiedValue;
    }

    @NotNull
    public String getLanguageName() {
        return "kotlin";
    }
}

