/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing;

import com.google.common.base.MoreObjects;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import io.temporal.opentracing.SpanBuilderProvider;
import io.temporal.opentracing.internal.ActionTypeAndNameSpanBuilderProvider;
import javax.annotation.Nonnull;

public class OpenTracingOptions {
    private static final OpenTracingOptions DEFAULT_INSTANCE = OpenTracingOptions.newBuilder().build();
    private final Tracer tracer;
    private final SpanBuilderProvider spanBuilderProvider;

    public static OpenTracingOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private OpenTracingOptions(Tracer tracer, SpanBuilderProvider spanBuilderProvider) {
        if (tracer == null) {
            throw new IllegalArgumentException("tracer shouldn't be null");
        }
        this.tracer = tracer;
        this.spanBuilderProvider = spanBuilderProvider;
    }

    @Nonnull
    public Tracer getTracer() {
        return this.tracer;
    }

    @Nonnull
    public SpanBuilderProvider getSpanBuilderProvider() {
        return this.spanBuilderProvider;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Tracer tracer;
        private SpanBuilderProvider spanBuilderProvider = new ActionTypeAndNameSpanBuilderProvider();

        private Builder() {
        }

        public Builder setTracer(Tracer tracer) {
            this.tracer = tracer;
            return this;
        }

        public Builder setSpanBuilderProvider(SpanBuilderProvider spanBuilderProvider) {
            this.spanBuilderProvider = spanBuilderProvider;
            return this;
        }

        public OpenTracingOptions build() {
            return new OpenTracingOptions((Tracer)MoreObjects.firstNonNull((Object)this.tracer, (Object)GlobalTracer.get()), this.spanBuilderProvider);
        }
    }
}

