/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import com.google.common.reflect.TypeToken;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.propagation.TextMapInjectAdapter;
import io.temporal.api.common.v1.Payload;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.Header;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

class OpenTracingContextAccessor {
    private static final String TRACER_HEADER_KEY = "_tracer-data";
    private static final Type HASH_MAP_STRING_STRING_TYPE = new TypeToken<HashMap<String, String>>(){}.getType();

    OpenTracingContextAccessor() {
    }

    public static void writeSpanContextToHeader(SpanContext spanContext, Header header, Tracer tracer) {
        Map<String, String> serializedSpanContext = OpenTracingContextAccessor.serializeSpanContextToMap(spanContext, tracer);
        Optional payload = DataConverter.getDefaultInstance().toPayload(serializedSpanContext);
        header.getValues().put(TRACER_HEADER_KEY, (Payload)payload.get());
    }

    private static Map<String, String> serializeSpanContextToMap(SpanContext spanContext, Tracer tracer) {
        HashMap<String, String> serialized = new HashMap<String, String>();
        tracer.inject(spanContext, Format.Builtin.TEXT_MAP_INJECT, (Object)new TextMapInjectAdapter(serialized));
        return serialized;
    }

    public static SpanContext readSpanContextFromHeader(Header header, Tracer tracer) {
        Payload payload = (Payload)header.getValues().get(TRACER_HEADER_KEY);
        if (payload == null) {
            return null;
        }
        Map serializedSpanContext = (Map)DataConverter.getDefaultInstance().fromPayload(payload, HashMap.class, HASH_MAP_STRING_STRING_TYPE);
        return OpenTracingContextAccessor.deserializeSpanContextFromMap(serializedSpanContext, tracer);
    }

    private static SpanContext deserializeSpanContextFromMap(Map<String, String> serializedSpanContext, Tracer tracer) {
        return tracer.extract(Format.Builtin.TEXT_MAP_EXTRACT, (Object)new TextMapExtractAdapter(serializedSpanContext));
    }
}

