/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptor;
import io.temporal.common.interceptors.WorkflowClientCallsInterceptorBase;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.SpanOperationType;
import io.temporal.opentracing.internal.OpenTracingContextAccessor;
import io.temporal.opentracing.internal.SpanFactory;

public class OpenTracingWorkflowClientCallsInterceptor
extends WorkflowClientCallsInterceptorBase {
    private final SpanFactory spanFactory;
    private final Tracer tracer;

    public OpenTracingWorkflowClientCallsInterceptor(WorkflowClientCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory) {
        super(next);
        this.spanFactory = spanFactory;
        this.tracer = options.getTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkflowClientCallsInterceptor.WorkflowStartOutput start(WorkflowClientCallsInterceptor.WorkflowStartInput input) {
        Span span = this.createAndPassWorkflowStartSpan(input, SpanOperationType.START_WORKFLOW);
        try {
            WorkflowClientCallsInterceptor.WorkflowStartOutput workflowStartOutput = super.start(input);
            return workflowStartOutput;
        }
        finally {
            span.finish();
        }
    }

    /*
     * Loose catch block
     */
    public WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput signalWithStart(WorkflowClientCallsInterceptor.WorkflowSignalWithStartInput input) {
        Span workflowStartSpan = this.createAndPassWorkflowStartSpan(input.getWorkflowStartInput(), SpanOperationType.SIGNAL_WITH_START_WORKFLOW);
        try {
            try (Scope scope = this.tracer.scopeManager().activate(workflowStartSpan);){
                WorkflowClientCallsInterceptor.WorkflowSignalWithStartOutput workflowSignalWithStartOutput = super.signalWithStart(input);
                return workflowSignalWithStartOutput;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            workflowStartSpan.finish();
        }
    }

    private Span createAndPassWorkflowStartSpan(WorkflowClientCallsInterceptor.WorkflowStartInput input, SpanOperationType operationType) {
        Span span = this.createWorkflowStartSpanBuilder(input, operationType).start();
        OpenTracingContextAccessor.writeSpanContextToHeader(span.context(), input.getHeader(), this.tracer);
        return span;
    }

    private Tracer.SpanBuilder createWorkflowStartSpanBuilder(WorkflowClientCallsInterceptor.WorkflowStartInput input, SpanOperationType operationType) {
        return this.spanFactory.createWorkflowStartSpan(this.tracer, operationType, input.getWorkflowType(), System.currentTimeMillis(), input.getWorkflowId());
    }
}

