/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.temporal.common.interceptors.Header;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptorBase;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.internal.OpenTracingContextAccessor;
import io.temporal.opentracing.internal.SpanFactory;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;

public class OpenTracingWorkflowOutboundCallsInterceptor
extends WorkflowOutboundCallsInterceptorBase {
    private final SpanFactory spanFactory;
    private final Tracer tracer;

    public OpenTracingWorkflowOutboundCallsInterceptor(WorkflowOutboundCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory) {
        super(next);
        this.spanFactory = spanFactory;
        this.tracer = options.getTracer();
    }

    /*
     * Loose catch block
     */
    public <R> WorkflowOutboundCallsInterceptor.ActivityOutput<R> executeActivity(WorkflowOutboundCallsInterceptor.ActivityInput<R> input) {
        if (!Workflow.isReplaying()) {
            Span activityStartSpan = this.createAndPassActivityStartSpan(input.getActivityName(), input.getHeader());
            try {
                try (Scope scope = this.tracer.scopeManager().activate(activityStartSpan);){
                    WorkflowOutboundCallsInterceptor.ActivityOutput activityOutput = super.executeActivity(input);
                    return activityOutput;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                activityStartSpan.finish();
            }
        }
        return super.executeActivity(input);
    }

    /*
     * Loose catch block
     */
    public <R> WorkflowOutboundCallsInterceptor.LocalActivityOutput<R> executeLocalActivity(WorkflowOutboundCallsInterceptor.LocalActivityInput<R> input) {
        if (!Workflow.isReplaying()) {
            Span activityStartSpan = this.createAndPassActivityStartSpan(input.getActivityName(), input.getHeader());
            try {
                try (Scope scope = this.tracer.scopeManager().activate(activityStartSpan);){
                    WorkflowOutboundCallsInterceptor.LocalActivityOutput localActivityOutput = super.executeLocalActivity(input);
                    return localActivityOutput;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                activityStartSpan.finish();
            }
        }
        return super.executeLocalActivity(input);
    }

    /*
     * Loose catch block
     */
    public <R> WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<R> executeChildWorkflow(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
        if (!Workflow.isReplaying()) {
            Span childWorkflowStartSpan = this.createAndPassChildWorkflowStartSpan(input);
            try {
                try (Scope scope = this.tracer.scopeManager().activate(childWorkflowStartSpan);){
                    WorkflowOutboundCallsInterceptor.ChildWorkflowOutput childWorkflowOutput = super.executeChildWorkflow(input);
                    return childWorkflowOutput;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                childWorkflowStartSpan.finish();
            }
        }
        return super.executeChildWorkflow(input);
    }

    private Span createAndPassActivityStartSpan(String activityName, Header header) {
        Span span = this.createActivityStartSpanBuilder(activityName).start();
        OpenTracingContextAccessor.writeSpanContextToHeader(span.context(), header, this.tracer);
        return span;
    }

    private Tracer.SpanBuilder createActivityStartSpanBuilder(String activityName) {
        WorkflowInfo workflowInfo = Workflow.getInfo();
        return this.spanFactory.createActivityStartSpan(this.tracer, activityName, Workflow.currentTimeMillis(), workflowInfo.getWorkflowId(), workflowInfo.getRunId());
    }

    private <R> Span createAndPassChildWorkflowStartSpan(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
        Span span = this.createChildWorkflowStartSpanBuilder(this.tracer, input).start();
        OpenTracingContextAccessor.writeSpanContextToHeader(span.context(), input.getHeader(), this.tracer);
        return span;
    }

    private <R> Tracer.SpanBuilder createChildWorkflowStartSpanBuilder(Tracer tracer, WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
        WorkflowInfo parentWorkflowInfo = Workflow.getInfo();
        return this.spanFactory.createChildWorkflowStartSpan(tracer, input.getWorkflowType(), System.currentTimeMillis(), input.getWorkflowId(), parentWorkflowInfo.getWorkflowId(), parentWorkflowInfo.getRunId());
    }
}

