/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import com.google.common.base.MoreObjects;
import com.uber.m3.util.ImmutableMap;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.SpanCreationContext;
import io.temporal.opentracing.SpanOperationType;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class SpanFactory {
    private final OpenTracingOptions options;

    public SpanFactory(OpenTracingOptions options) {
        this.options = options;
    }

    public Tracer.SpanBuilder createWorkflowStartSpan(Tracer tracer, SpanOperationType operationType, String workflowType, long startTimeMs, String workflowId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(operationType).setActionName(workflowType).setWorkflowId(workflowId).build();
        return this.createSpan(context, tracer, startTimeMs, null, "follows_from");
    }

    public Tracer.SpanBuilder createChildWorkflowStartSpan(Tracer tracer, String childWorkflowType, long startTimeMs, String workflowId, String parentWorkflowId, String parentRunId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_CHILD_WORKFLOW).setActionName(childWorkflowType).setWorkflowId(workflowId).setParentWorkflowId(parentWorkflowId).setParentRunId(parentRunId).build();
        return this.createSpan(context, tracer, startTimeMs, null, "follows_from");
    }

    public Tracer.SpanBuilder createWorkflowRunSpan(Tracer tracer, String workflowType, long startTimeMs, String workflowId, String runId, SpanContext workflowStartSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.RUN_WORKFLOW).setActionName(workflowType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, startTimeMs, workflowStartSpanContext, "follows_from");
    }

    public Tracer.SpanBuilder createActivityStartSpan(Tracer tracer, String activityType, long startTimeMs, String workflowId, String runId) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.START_ACTIVITY).setActionName(activityType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, startTimeMs, null, "child_of");
    }

    public Tracer.SpanBuilder createActivityRunSpan(Tracer tracer, String activityType, long startTimeMs, String workflowId, String runId, SpanContext activityStartSpanContext) {
        SpanCreationContext context = SpanCreationContext.newBuilder().setSpanOperationType(SpanOperationType.RUN_ACTIVITY).setActionName(activityType).setWorkflowId(workflowId).setRunId(runId).build();
        return this.createSpan(context, tracer, startTimeMs, activityStartSpanContext, "child_of");
    }

    public void logFail(Span toSpan, Throwable failReason) {
        toSpan.setTag("failed", true);
        ImmutableMap logPayload = ImmutableMap.of((Object)"failureMessage", (Object)failReason.getMessage(), (Object)"failureCause", (Object)failReason);
        toSpan.log(System.currentTimeMillis(), (Map)logPayload);
    }

    private Tracer.SpanBuilder createSpan(SpanCreationContext context, Tracer tracer, long startTimeMs, @Nullable SpanContext parentSpanContext, @Nullable String parentReferenceType) {
        Span activeSpan = tracer.activeSpan();
        SpanContext parent = activeSpan != null ? activeSpan.context() : parentSpanContext;
        Tracer.SpanBuilder builder = this.options.getSpanBuilderProvider().createSpanBuilder(tracer, context);
        long startTimeMc = TimeUnit.MILLISECONDS.toMicros(startTimeMs);
        builder.withStartTimestamp(startTimeMc);
        if (parent != null) {
            builder.addReference((String)MoreObjects.firstNonNull((Object)parentReferenceType, (Object)"follows_from"), parent);
        }
        return builder;
    }
}

