/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import io.nexusrpc.OperationUnsuccessfulException;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.temporal.common.interceptors.NexusOperationInboundCallsInterceptor;
import io.temporal.common.interceptors.NexusOperationInboundCallsInterceptorBase;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.internal.ContextAccessor;
import io.temporal.opentracing.internal.SpanFactory;

public class OpenTracingNexusOperationInboundCallsInterceptor
extends NexusOperationInboundCallsInterceptorBase {
    private final OpenTracingOptions options;
    private final SpanFactory spanFactory;
    private final Tracer tracer;
    private final ContextAccessor contextAccessor;

    public OpenTracingNexusOperationInboundCallsInterceptor(NexusOperationInboundCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory, ContextAccessor contextAccessor) {
        super(next);
        this.options = options;
        this.spanFactory = spanFactory;
        this.tracer = options.getTracer();
        this.contextAccessor = contextAccessor;
    }

    public NexusOperationInboundCallsInterceptor.StartOperationOutput startOperation(NexusOperationInboundCallsInterceptor.StartOperationInput input) throws OperationUnsuccessfulException {
        SpanContext rootSpanContext = this.contextAccessor.readSpanContextFromHeader(input.getOperationContext().getHeaders(), this.tracer);
        Span operationStartSpan = this.spanFactory.createStartNexusOperationSpan(this.tracer, input.getOperationContext().getService(), input.getOperationContext().getOperation(), rootSpanContext).start();
        try {
            NexusOperationInboundCallsInterceptor.StartOperationOutput startOperationOutput;
            block11: {
                Scope scope = this.tracer.scopeManager().activate(operationStartSpan);
                try {
                    startOperationOutput = super.startOperation(input);
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        this.spanFactory.logFail(operationStartSpan, t);
                        throw t;
                    }
                }
                scope.close();
            }
            return startOperationOutput;
        }
        finally {
            operationStartSpan.finish();
        }
    }

    public NexusOperationInboundCallsInterceptor.CancelOperationOutput cancelOperation(NexusOperationInboundCallsInterceptor.CancelOperationInput input) {
        SpanContext rootSpanContext = this.contextAccessor.readSpanContextFromHeader(input.getOperationContext().getHeaders(), this.tracer);
        Span operationCancelSpan = this.spanFactory.createCancelNexusOperationSpan(this.tracer, input.getOperationContext().getService(), input.getOperationContext().getOperation(), rootSpanContext).start();
        try {
            NexusOperationInboundCallsInterceptor.CancelOperationOutput cancelOperationOutput;
            block11: {
                Scope scope = this.tracer.scopeManager().activate(operationCancelSpan);
                try {
                    cancelOperationOutput = super.cancelOperation(input);
                    if (scope == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (scope != null) {
                            try {
                                scope.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        this.spanFactory.logFail(operationCancelSpan, t);
                        throw t;
                    }
                }
                scope.close();
            }
            return cancelOperationOutput;
        }
        finally {
            operationCancelSpan.finish();
        }
    }
}

