/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing;

import io.nexusrpc.handler.OperationContext;
import io.temporal.common.interceptors.ActivityInboundCallsInterceptor;
import io.temporal.common.interceptors.NexusOperationInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkerInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.internal.ContextAccessor;
import io.temporal.opentracing.internal.OpenTracingActivityInboundCallsInterceptor;
import io.temporal.opentracing.internal.OpenTracingNexusOperationInboundCallsInterceptor;
import io.temporal.opentracing.internal.OpenTracingWorkflowInboundCallsInterceptor;
import io.temporal.opentracing.internal.SpanFactory;

public class OpenTracingWorkerInterceptor
implements WorkerInterceptor {
    private final OpenTracingOptions options;
    private final SpanFactory spanFactory;
    private final ContextAccessor contextAccessor;

    public OpenTracingWorkerInterceptor() {
        this(OpenTracingOptions.getDefaultInstance());
    }

    public OpenTracingWorkerInterceptor(OpenTracingOptions options) {
        this.options = options;
        this.spanFactory = new SpanFactory(options);
        this.contextAccessor = new ContextAccessor(options);
    }

    public WorkflowInboundCallsInterceptor interceptWorkflow(WorkflowInboundCallsInterceptor next) {
        return new OpenTracingWorkflowInboundCallsInterceptor(next, this.options, this.spanFactory, this.contextAccessor);
    }

    public ActivityInboundCallsInterceptor interceptActivity(ActivityInboundCallsInterceptor next) {
        return new OpenTracingActivityInboundCallsInterceptor(next, this.options, this.spanFactory, this.contextAccessor);
    }

    public NexusOperationInboundCallsInterceptor interceptNexusOperation(OperationContext context, NexusOperationInboundCallsInterceptor next) {
        return new OpenTracingNexusOperationInboundCallsInterceptor(next, this.options, this.spanFactory, this.contextAccessor);
    }
}

