/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import com.google.common.base.MoreObjects;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptorBase;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.internal.ContextAccessor;
import io.temporal.opentracing.internal.SpanFactory;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.Workflow;
import io.temporal.workflow.WorkflowInfo;
import io.temporal.workflow.unsafe.WorkflowUnsafe;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class OpenTracingWorkflowOutboundCallsInterceptor
extends WorkflowOutboundCallsInterceptorBase {
    private final SpanFactory spanFactory;
    private final Tracer tracer;
    private final ContextAccessor contextAccessor;

    public OpenTracingWorkflowOutboundCallsInterceptor(WorkflowOutboundCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory, ContextAccessor contextAccessor) {
        super(next);
        this.spanFactory = spanFactory;
        this.tracer = options.getTracer();
        this.contextAccessor = contextAccessor;
    }

    public <R> WorkflowOutboundCallsInterceptor.ActivityOutput<R> executeActivity(WorkflowOutboundCallsInterceptor.ActivityInput<R> input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span capturedSpan = this.tracer.scopeManager().activeSpan();
            Span activityStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createActivityStartSpanBuilder(input.getActivityName()).start(), input.getHeader(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.ActivityOutput activityOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(activityStartSpan);
                    try {
                        WorkflowOutboundCallsInterceptor.ActivityOutput output = super.executeActivity(input);
                        activityOutput = new WorkflowOutboundCallsInterceptor.ActivityOutput(output.getActivityId(), new PromiseWrapper(capturedSpan, output.getResult()));
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return activityOutput;
            }
            finally {
                activityStartSpan.finish();
            }
        }
        return super.executeActivity(input);
    }

    public <R> WorkflowOutboundCallsInterceptor.LocalActivityOutput<R> executeLocalActivity(WorkflowOutboundCallsInterceptor.LocalActivityInput<R> input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span capturedSpan = this.tracer.scopeManager().activeSpan();
            Span activityStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createActivityStartSpanBuilder(input.getActivityName()).start(), input.getHeader(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.LocalActivityOutput localActivityOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(activityStartSpan);
                    try {
                        WorkflowOutboundCallsInterceptor.LocalActivityOutput output = super.executeLocalActivity(input);
                        localActivityOutput = new WorkflowOutboundCallsInterceptor.LocalActivityOutput(new PromiseWrapper(capturedSpan, output.getResult()));
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return localActivityOutput;
            }
            finally {
                activityStartSpan.finish();
            }
        }
        return super.executeLocalActivity(input);
    }

    public <R> WorkflowOutboundCallsInterceptor.ChildWorkflowOutput<R> executeChildWorkflow(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span capturedSpan = this.tracer.scopeManager().activeSpan();
            Span childWorkflowStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createChildWorkflowStartSpanBuilder(input).start(), input.getHeader(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.ChildWorkflowOutput childWorkflowOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(childWorkflowStartSpan);
                    try {
                        WorkflowOutboundCallsInterceptor.ChildWorkflowOutput output = super.executeChildWorkflow(input);
                        childWorkflowOutput = new WorkflowOutboundCallsInterceptor.ChildWorkflowOutput(new PromiseWrapper(capturedSpan, output.getResult()), new PromiseWrapper(capturedSpan, output.getWorkflowExecution()));
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return childWorkflowOutput;
            }
            finally {
                childWorkflowStartSpan.finish();
            }
        }
        return super.executeChildWorkflow(input);
    }

    public <R> WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput<R> executeNexusOperation(WorkflowOutboundCallsInterceptor.ExecuteNexusOperationInput<R> input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span capturedSpan = this.tracer.scopeManager().activeSpan();
            Span nexusOperationExecuteSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createStartNexusOperationSpanBuilder(input).start(), (Map<String, String>)input.getHeaders(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput executeNexusOperationOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(nexusOperationExecuteSpan);
                    try {
                        WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput output = super.executeNexusOperation(input);
                        executeNexusOperationOutput = new WorkflowOutboundCallsInterceptor.ExecuteNexusOperationOutput(new PromiseWrapper(capturedSpan, output.getResult()), new PromiseWrapper(capturedSpan, output.getOperationExecution()));
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return executeNexusOperationOutput;
            }
            finally {
                nexusOperationExecuteSpan.finish();
            }
        }
        return super.executeNexusOperation(input);
    }

    public WorkflowOutboundCallsInterceptor.SignalExternalOutput signalExternalWorkflow(WorkflowOutboundCallsInterceptor.SignalExternalInput input) {
        if (!WorkflowUnsafe.isReplaying()) {
            Span capturedSpan = this.tracer.scopeManager().activeSpan();
            WorkflowInfo workflowInfo = Workflow.getInfo();
            Span childWorkflowStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.spanFactory.createExternalWorkflowSignalSpan(this.tracer, input.getSignalName(), workflowInfo.getWorkflowId(), workflowInfo.getRunId()).start(), input.getHeader(), this.tracer);
            try {
                WorkflowOutboundCallsInterceptor.SignalExternalOutput signalExternalOutput;
                block10: {
                    Scope ignored = this.tracer.scopeManager().activate(childWorkflowStartSpan);
                    try {
                        WorkflowOutboundCallsInterceptor.SignalExternalOutput output = super.signalExternalWorkflow(input);
                        signalExternalOutput = new WorkflowOutboundCallsInterceptor.SignalExternalOutput(new PromiseWrapper(capturedSpan, output.getResult()));
                        if (ignored == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return signalExternalOutput;
            }
            finally {
                childWorkflowStartSpan.finish();
            }
        }
        return super.signalExternalWorkflow(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueAsNew(WorkflowOutboundCallsInterceptor.ContinueAsNewInput input) {
        block10: {
            if (!WorkflowUnsafe.isReplaying()) {
                Span continueAsNewStartSpan = this.contextAccessor.writeSpanContextToHeader(() -> this.createContinueAsNewWorkflowStartSpanBuilder(input).start(), input.getHeader(), this.tracer);
                try (Scope ignored = this.tracer.scopeManager().activate(continueAsNewStartSpan);){
                    super.continueAsNew(input);
                    break block10;
                }
                finally {
                    continueAsNewStartSpan.finish();
                }
            }
            super.continueAsNew(input);
        }
    }

    public Object newChildThread(Runnable runnable, boolean detached, String name) {
        Span activeSpan = this.tracer.scopeManager().activeSpan();
        Runnable wrappedRunnable = activeSpan != null ? () -> {
            try (Scope ignored = this.tracer.scopeManager().activate(activeSpan);){
                runnable.run();
            }
        } : runnable;
        return super.newChildThread(wrappedRunnable, detached, name);
    }

    private Tracer.SpanBuilder createActivityStartSpanBuilder(String activityName) {
        WorkflowInfo workflowInfo = Workflow.getInfo();
        return this.spanFactory.createActivityStartSpan(this.tracer, activityName, workflowInfo.getWorkflowId(), workflowInfo.getRunId());
    }

    private <R> Tracer.SpanBuilder createChildWorkflowStartSpanBuilder(WorkflowOutboundCallsInterceptor.ChildWorkflowInput<R> input) {
        WorkflowInfo parentWorkflowInfo = Workflow.getInfo();
        return this.spanFactory.createChildWorkflowStartSpan(this.tracer, input.getWorkflowType(), input.getWorkflowId(), Workflow.currentTimeMillis(), parentWorkflowInfo.getWorkflowId(), parentWorkflowInfo.getRunId());
    }

    private <R> Tracer.SpanBuilder createStartNexusOperationSpanBuilder(WorkflowOutboundCallsInterceptor.ExecuteNexusOperationInput<R> input) {
        WorkflowInfo parentWorkflowInfo = Workflow.getInfo();
        return this.spanFactory.createStartNexusOperationSpan(this.tracer, input.getService(), input.getOperation(), parentWorkflowInfo.getWorkflowId(), parentWorkflowInfo.getRunId());
    }

    private Tracer.SpanBuilder createContinueAsNewWorkflowStartSpanBuilder(WorkflowOutboundCallsInterceptor.ContinueAsNewInput input) {
        WorkflowInfo continuedWorkflowInfo = Workflow.getInfo();
        return this.spanFactory.createContinueAsNewWorkflowStartSpan(this.tracer, (String)MoreObjects.firstNonNull((Object)input.getWorkflowType(), (Object)continuedWorkflowInfo.getWorkflowType()), continuedWorkflowInfo.getWorkflowId(), continuedWorkflowInfo.getRunId());
    }

    private class PromiseWrapper<R>
    implements Promise<R> {
        private final Span capturedSpan;
        private final Promise<R> delegate;

        PromiseWrapper(Span capturedSpan, Promise<R> delegate) {
            this.capturedSpan = capturedSpan;
            this.delegate = delegate;
        }

        private <O> O wrap(Functions.Func<O> fn) {
            Span activeSpan = OpenTracingWorkflowOutboundCallsInterceptor.this.tracer.scopeManager().activeSpan();
            if (activeSpan == null && this.capturedSpan != null) {
                try (Scope ignored = OpenTracingWorkflowOutboundCallsInterceptor.this.tracer.scopeManager().activate(this.capturedSpan);){
                    Object object = fn.apply();
                    return (O)object;
                }
            }
            return (O)fn.apply();
        }

        public boolean isCompleted() {
            return this.delegate.isCompleted();
        }

        public R get() {
            return (R)this.delegate.get();
        }

        public R cancellableGet() {
            return (R)this.delegate.cancellableGet();
        }

        public R get(long timeout, TimeUnit unit) throws TimeoutException {
            return (R)this.delegate.get(timeout, unit);
        }

        public R cancellableGet(long timeout, TimeUnit unit) throws TimeoutException {
            return (R)this.delegate.cancellableGet(timeout, unit);
        }

        public RuntimeException getFailure() {
            return this.delegate.getFailure();
        }

        public <U> Promise<U> thenApply(Functions.Func1<? super R, ? extends U> fn) {
            return this.delegate.thenApply((Functions.Func1 & Serializable)r -> this.wrap((Functions.Func & Serializable)() -> fn.apply(r)));
        }

        public <U> Promise<U> handle(Functions.Func2<? super R, RuntimeException, ? extends U> fn) {
            return this.delegate.handle((Functions.Func2 & Serializable)(r, e) -> this.wrap((Functions.Func & Serializable)() -> fn.apply(r, e)));
        }

        public <U> Promise<U> thenCompose(Functions.Func1<? super R, ? extends Promise<U>> fn) {
            return this.delegate.thenCompose((Functions.Func1 & Serializable)r -> (Promise)this.wrap((Functions.Func & Serializable)() -> (Promise)fn.apply(r)));
        }

        public Promise<R> exceptionally(Functions.Func1<Throwable, ? extends R> fn) {
            return this.delegate.exceptionally((Functions.Func1 & Serializable)t -> this.wrap((Functions.Func & Serializable)() -> fn.apply(t)));
        }
    }
}

