/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.opentracing.internal;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptor;
import io.temporal.common.interceptors.WorkflowInboundCallsInterceptorBase;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.sync.DestroyWorkflowThreadError;
import io.temporal.opentracing.OpenTracingOptions;
import io.temporal.opentracing.internal.ContextAccessor;
import io.temporal.opentracing.internal.OpenTracingWorkflowOutboundCallsInterceptor;
import io.temporal.opentracing.internal.SpanFactory;
import io.temporal.workflow.Workflow;

public class OpenTracingWorkflowInboundCallsInterceptor
extends WorkflowInboundCallsInterceptorBase {
    private final OpenTracingOptions options;
    private final SpanFactory spanFactory;
    private final ContextAccessor contextAccessor;

    public OpenTracingWorkflowInboundCallsInterceptor(WorkflowInboundCallsInterceptor next, OpenTracingOptions options, SpanFactory spanFactory, ContextAccessor contextAccessor) {
        super(next);
        this.options = options;
        this.spanFactory = spanFactory;
        this.contextAccessor = contextAccessor;
    }

    public void init(WorkflowOutboundCallsInterceptor outboundCalls) {
        super.init((WorkflowOutboundCallsInterceptor)new OpenTracingWorkflowOutboundCallsInterceptor(outboundCalls, this.options, this.spanFactory, this.contextAccessor));
    }

    public WorkflowInboundCallsInterceptor.WorkflowOutput execute(WorkflowInboundCallsInterceptor.WorkflowInput input) {
        Tracer tracer = this.options.getTracer();
        SpanContext rootSpanContext = this.contextAccessor.readSpanContextFromHeader(input.getHeader(), tracer);
        Span workflowRunSpan = this.spanFactory.createWorkflowRunSpan(tracer, Workflow.getInfo().getWorkflowType(), Workflow.getInfo().getWorkflowId(), Workflow.getInfo().getRunId(), rootSpanContext).start();
        try {
            WorkflowInboundCallsInterceptor.WorkflowOutput workflowOutput;
            block13: {
                Scope ignored = tracer.scopeManager().activate(workflowRunSpan);
                try {
                    workflowOutput = super.execute(input);
                    if (ignored == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        if (t instanceof DestroyWorkflowThreadError) {
                            this.spanFactory.logEviction(workflowRunSpan);
                        } else {
                            this.spanFactory.logFail(workflowRunSpan, t);
                        }
                        throw t;
                    }
                }
                ignored.close();
            }
            return workflowOutput;
        }
        finally {
            workflowRunSpan.finish();
        }
    }

    public void handleSignal(WorkflowInboundCallsInterceptor.SignalInput input) {
        Tracer tracer = this.options.getTracer();
        SpanContext rootSpanContext = this.contextAccessor.readSpanContextFromHeader(input.getHeader(), tracer);
        Span workflowSignalSpan = this.spanFactory.createWorkflowHandleSignalSpan(tracer, input.getSignalName(), Workflow.getInfo().getWorkflowId(), Workflow.getInfo().getRunId(), rootSpanContext).start();
        try (Scope ignored = tracer.scopeManager().activate(workflowSignalSpan);){
            super.handleSignal(input);
        }
        catch (Throwable t) {
            if (t instanceof DestroyWorkflowThreadError) {
                this.spanFactory.logEviction(workflowSignalSpan);
            } else {
                this.spanFactory.logFail(workflowSignalSpan, t);
            }
            throw t;
        }
        finally {
            workflowSignalSpan.finish();
        }
    }

    public WorkflowInboundCallsInterceptor.QueryOutput handleQuery(WorkflowInboundCallsInterceptor.QueryInput input) {
        Tracer tracer = this.options.getTracer();
        SpanContext rootSpanContext = this.contextAccessor.readSpanContextFromHeader(input.getHeader(), tracer);
        Span workflowQuerySpan = this.spanFactory.createWorkflowHandleQuerySpan(tracer, input.getQueryName(), rootSpanContext).start();
        try {
            WorkflowInboundCallsInterceptor.QueryOutput queryOutput;
            block13: {
                Scope ignored = tracer.scopeManager().activate(workflowQuerySpan);
                try {
                    queryOutput = super.handleQuery(input);
                    if (ignored == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        if (t instanceof DestroyWorkflowThreadError) {
                            this.spanFactory.logEviction(workflowQuerySpan);
                        } else {
                            this.spanFactory.logFail(workflowQuerySpan, t);
                        }
                        throw t;
                    }
                }
                ignored.close();
            }
            return queryOutput;
        }
        finally {
            workflowQuerySpan.finish();
        }
    }

    public WorkflowInboundCallsInterceptor.UpdateOutput executeUpdate(WorkflowInboundCallsInterceptor.UpdateInput input) {
        Tracer tracer = this.options.getTracer();
        SpanContext rootSpanContext = this.contextAccessor.readSpanContextFromHeader(input.getHeader(), tracer);
        Span workflowSignalSpan = this.spanFactory.createWorkflowExecuteUpdateSpan(tracer, input.getUpdateName(), Workflow.getInfo().getWorkflowId(), Workflow.getInfo().getRunId(), rootSpanContext).start();
        try {
            WorkflowInboundCallsInterceptor.UpdateOutput updateOutput;
            block13: {
                Scope ignored = tracer.scopeManager().activate(workflowSignalSpan);
                try {
                    updateOutput = super.executeUpdate(input);
                    if (ignored == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable t) {
                        if (t instanceof DestroyWorkflowThreadError) {
                            this.spanFactory.logEviction(workflowSignalSpan);
                        } else {
                            this.spanFactory.logFail(workflowSignalSpan, t);
                        }
                        throw t;
                    }
                }
                ignored.close();
            }
            return updateOutput;
        }
        finally {
            workflowSignalSpan.finish();
        }
    }
}

