/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.common.MethodRetry;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.internal.sync.POJOActivityInterfaceMetadata;
import io.temporal.internal.sync.POJOActivityMethodMetadata;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

abstract class ActivityInvocationHandlerBase
implements InvocationHandler {
    private final Map<Method, Function<Object[], Object>> methodFunctions = new HashMap<Method, Function<Object[], Object>>();

    ActivityInvocationHandlerBase() {
    }

    static <T> T newProxy(Class<T> activityInterface, InvocationHandler invocationHandler) {
        return (T)Proxy.newProxyInstance(activityInterface.getClassLoader(), new Class[]{activityInterface, AsyncInternal.AsyncMarker.class}, invocationHandler);
    }

    protected void init(Class<?> activityInterface) {
        POJOActivityInterfaceMetadata activityMetadata = POJOActivityInterfaceMetadata.newInstance(activityInterface);
        for (POJOActivityMethodMetadata methodMetadata : activityMetadata.getMethodsMetadata()) {
            Method method = methodMetadata.getMethod();
            String activityType = methodMetadata.getName();
            MethodRetry methodRetry = method.getAnnotation(MethodRetry.class);
            Function<Object[], Object> function = this.getActivityFunc(method, methodRetry, activityType);
            this.methodFunctions.put(method, function);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Function<Object[], Object> function = this.methodFunctions.get(method);
        if (function == null) {
            throw new IllegalArgumentException("Unexpected method: " + method);
        }
        return InternalUtils.getValueOrDefault(function.apply(args), method.getReturnType());
    }

    protected abstract Function<Object[], Object> getActivityFunc(Method var1, MethodRetry var2, String var3);
}

