/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Workflow;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;

class CancellationScopeImpl
implements CancellationScope {
    private static final ThreadLocal<Deque<CancellationScopeImpl>> scopeStack = ThreadLocal.withInitial(ArrayDeque::new);
    private boolean detached;
    private CompletablePromise<String> cancellationPromise;
    private final Runnable runnable;
    private CancellationScopeImpl parent;
    private final Set<CancellationScopeImpl> children = new HashSet<CancellationScopeImpl>();
    private boolean cancelRequested;
    private String reason;

    static CancellationScopeImpl current() {
        if (scopeStack.get().isEmpty()) {
            throw new IllegalStateException("Cannot be called by non workflow thread");
        }
        return scopeStack.get().peekFirst();
    }

    private static void pushCurrent(CancellationScopeImpl scope) {
        scopeStack.get().addFirst(scope);
    }

    private static void popCurrent(CancellationScopeImpl expected) {
        CancellationScopeImpl current = scopeStack.get().pollFirst();
        if (current != expected) {
            throw new Error("Unexpected scope");
        }
        if (!current.detached) {
            current.parent.removeChild(current);
        }
    }

    CancellationScopeImpl(boolean ignoreParentCancellation, Runnable runnable) {
        this(ignoreParentCancellation, runnable, CancellationScopeImpl.current());
    }

    CancellationScopeImpl(boolean detached, Runnable runnable, CancellationScopeImpl parent) {
        this.detached = detached;
        this.runnable = runnable;
        this.setParent(parent);
    }

    public CancellationScopeImpl(boolean ignoreParentCancellation, Functions.Proc1<CancellationScope> proc) {
        this.detached = ignoreParentCancellation;
        this.runnable = () -> proc.apply(this);
        this.setParent(CancellationScopeImpl.current());
    }

    private void setParent(CancellationScopeImpl parent) {
        if (parent == null) {
            this.detached = true;
            return;
        }
        if (!this.detached) {
            this.parent = parent;
            parent.addChild(this);
            if (parent.isCancelRequested()) {
                this.cancel(parent.getCancellationReason());
            }
        }
    }

    @Override
    public void run() {
        try {
            CancellationScopeImpl.pushCurrent(this);
            this.runnable.run();
        }
        finally {
            CancellationScopeImpl.popCurrent(this);
        }
    }

    @Override
    public boolean isDetached() {
        return this.detached;
    }

    @Override
    public void cancel() {
        this.cancelRequested = true;
        this.reason = null;
        for (CancellationScopeImpl child : this.children) {
            child.cancel();
        }
        if (this.cancellationPromise != null) {
            this.cancellationPromise.complete(null);
        }
    }

    @Override
    public void cancel(String reason) {
        this.cancelRequested = true;
        this.reason = reason;
        for (CancellationScopeImpl child : this.children) {
            child.cancel(reason);
        }
        if (this.cancellationPromise != null) {
            this.cancellationPromise.complete(reason);
        }
    }

    @Override
    public String getCancellationReason() {
        return this.reason;
    }

    @Override
    public boolean isCancelRequested() {
        return this.cancelRequested;
    }

    public CompletablePromise<String> getCancellationRequest() {
        if (this.cancellationPromise == null) {
            this.cancellationPromise = Workflow.newPromise();
            if (this.isCancelRequested()) {
                this.cancellationPromise.complete(this.getCancellationReason());
            }
        }
        return this.cancellationPromise;
    }

    private void addChild(CancellationScopeImpl scope) {
        this.children.add(scope);
    }

    private void removeChild(CancellationScopeImpl scope) {
        if (!this.children.remove(scope)) {
            throw new Error("Not a child");
        }
    }
}

