/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.internal.sync.DeterministicRunnerImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

class DeterministicRunnerWrapper
implements InvocationHandler {
    private final InvocationHandler invocationHandler;

    DeterministicRunnerWrapper(InvocationHandler invocationHandler) {
        this.invocationHandler = Objects.requireNonNull(invocationHandler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        CompletableFuture result = new CompletableFuture();
        DeterministicRunnerImpl runner = new DeterministicRunnerImpl(() -> {
            try {
                result.complete(this.invocationHandler.invoke(proxy, method, args));
            }
            catch (Throwable throwable) {
                result.completeExceptionally(throwable);
            }
        });
        runner.runUntilAllBlocked();
        try {
            return result.get();
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }
}

