/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.internal.sync.AsyncInternal;
import io.temporal.workflow.CancelExternalWorkflowException;
import io.temporal.workflow.ExternalWorkflowStub;
import io.temporal.workflow.Promise;
import io.temporal.workflow.SignalExternalWorkflowException;
import java.util.Objects;

class ExternalWorkflowStubImpl
implements ExternalWorkflowStub {
    private final WorkflowOutboundCallsInterceptor outboundCallsInterceptor;
    private final WorkflowExecution execution;

    public ExternalWorkflowStubImpl(WorkflowExecution execution, WorkflowOutboundCallsInterceptor outboundCallsInterceptor) {
        this.outboundCallsInterceptor = Objects.requireNonNull(outboundCallsInterceptor);
        this.execution = Objects.requireNonNull(execution);
    }

    @Override
    public WorkflowExecution getExecution() {
        return this.execution;
    }

    @Override
    public void signal(String signalName, Object ... args) {
        Promise<Void> signaled = this.outboundCallsInterceptor.signalExternalWorkflow(this.execution, signalName, args);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(signaled);
            return;
        }
        try {
            signaled.get();
        }
        catch (SignalExternalWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }

    @Override
    public void cancel() {
        Promise<Void> cancelRequested = this.outboundCallsInterceptor.cancelWorkflow(this.execution);
        if (AsyncInternal.isAsync()) {
            AsyncInternal.setAsyncResult(cancelRequested);
            return;
        }
        try {
            cancelRequested.get();
        }
        catch (CancelExternalWorkflowException e) {
            e.setStackTrace(Thread.currentThread().getStackTrace());
            throw e;
        }
    }
}

