/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.activity.ActivityMethod;
import io.temporal.common.MethodRetry;
import io.temporal.internal.sync.POJOActivityInterfaceMetadata;
import io.temporal.internal.sync.POJOActivityMethodMetadata;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class POJOActivityImplMetadata {
    private final Map<String, POJOActivityMethodMetadata> byName = new HashMap<String, POJOActivityMethodMetadata>();

    public static POJOActivityImplMetadata newInstance(Class<?> implementationClass) {
        return new POJOActivityImplMetadata(implementationClass);
    }

    private POJOActivityImplMetadata(Class<?> implClass) {
        if (implClass.isInterface() || implClass.isPrimitive() || implClass.isAnnotation() || implClass.isArray() || implClass.isEnum()) {
            throw new IllegalArgumentException("concrete class expected: " + implClass);
        }
        for (Method method : implClass.getMethods()) {
            if (method.getAnnotation(ActivityMethod.class) != null) {
                throw new IllegalArgumentException("Found @ActivityMethod annotation on \"" + method + "\" This annotation can be used only on the interface method it implements.");
            }
            if (method.getAnnotation(MethodRetry.class) == null) continue;
            throw new IllegalArgumentException("Found @MethodRetry annotation on \"" + method + "\" This annotation can be used only on the interface method it implements.");
        }
        Class<?>[] interfaces = implClass.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            POJOActivityInterfaceMetadata interfaceMetadata = POJOActivityInterfaceMetadata.newImplementationInterface(anInterface);
            List<POJOActivityMethodMetadata> methods = interfaceMetadata.getMethodsMetadata();
            for (POJOActivityMethodMetadata methodMetadata : methods) {
                POJOActivityMethodMetadata registeredMM = this.byName.put(methodMetadata.getName(), methodMetadata);
                if (registeredMM == null || registeredMM.equals(methodMetadata)) continue;
                throw new IllegalArgumentException("Duplicated name: \"" + methodMetadata.getName() + "\" declared at \"" + registeredMM.getMethod() + "\" registered through \"" + registeredMM.getInterfaceType() + "\" and \"" + methodMetadata.getMethod() + "\" registered through \"" + methodMetadata.getInterfaceType() + "\"");
            }
        }
        if (this.byName.isEmpty()) {
            throw new IllegalArgumentException("Class doesn't implement any non empty interface annotated with @ActivityInterface: " + implClass.getName());
        }
    }

    public Set<String> getActivityTypes() {
        return this.byName.keySet();
    }

    public POJOActivityMethodMetadata getMethodMetadata(String activityType) {
        POJOActivityMethodMetadata result = this.byName.get(activityType);
        if (result == null) {
            throw new IllegalArgumentException("Unknown activity type: " + activityType);
        }
        return result;
    }
}

