/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.common.interceptors.ActivityInterceptor;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.sync.POJOActivityTaskHandler;
import io.temporal.internal.worker.ActivityWorker;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.serviceclient.WorkflowServiceStubs;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SyncActivityWorker
implements SuspendableWorker {
    private final ActivityWorker worker;
    private final POJOActivityTaskHandler taskHandler;
    private final ScheduledExecutorService heartbeatExecutor = Executors.newScheduledThreadPool(4);

    public SyncActivityWorker(WorkflowServiceStubs service, String namespace, String taskQueue, double taskQueueActivitiesPerSecond, ActivityInterceptor[] activityInterceptors, SingleWorkerOptions options) {
        this.taskHandler = new POJOActivityTaskHandler(service, namespace, options.getDataConverter(), this.heartbeatExecutor, activityInterceptors);
        this.worker = new ActivityWorker(service, namespace, taskQueue, taskQueueActivitiesPerSecond, options, this.taskHandler);
    }

    public void setActivitiesImplementation(Object ... activitiesImplementation) {
        this.taskHandler.setActivitiesImplementation(activitiesImplementation);
    }

    @Override
    public void start() {
        this.worker.start();
    }

    @Override
    public boolean isStarted() {
        return this.worker.isStarted();
    }

    @Override
    public boolean isShutdown() {
        return this.worker.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.worker.isTerminated() && this.heartbeatExecutor.isTerminated();
    }

    @Override
    public void shutdown() {
        this.worker.shutdown();
        this.heartbeatExecutor.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.worker.shutdownNow();
        this.heartbeatExecutor.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = unit.toMillis(timeout);
        timeoutMillis = InternalUtils.awaitTermination(this.worker, timeoutMillis);
        InternalUtils.awaitTermination(this.heartbeatExecutor, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.worker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.worker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.worker.isSuspended();
    }
}

