/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.history.v1.HistoryEvent;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.api.query.v1.WorkflowQuery;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.internal.replay.ReplayWorkflow;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.DeterministicRunner;
import io.temporal.internal.sync.POJOWorkflowImplementationFactory;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import io.temporal.internal.sync.WorkflowExecuteRunnable;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.worker.WorkflowExecutionException;
import io.temporal.worker.WorkflowImplementationOptions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyncWorkflow
implements ReplayWorkflow {
    private static final Logger log = LoggerFactory.getLogger(SyncWorkflow.class);
    private final DataConverter dataConverter;
    private final List<ContextPropagator> contextPropagators;
    private final ExecutorService threadPool;
    private final SyncWorkflowDefinition workflow;
    WorkflowImplementationOptions workflowImplementationOptions;
    private final WorkflowExecutorCache cache;
    private WorkflowExecuteRunnable workflowProc;
    private DeterministicRunner runner;

    public SyncWorkflow(SyncWorkflowDefinition workflow, WorkflowImplementationOptions workflowImplementationOptions, DataConverter dataConverter, ExecutorService threadPool, WorkflowExecutorCache cache, List<ContextPropagator> contextPropagators) {
        this.workflow = Objects.requireNonNull(workflow);
        this.workflowImplementationOptions = workflowImplementationOptions == null ? WorkflowImplementationOptions.newBuilder().build() : workflowImplementationOptions;
        this.dataConverter = Objects.requireNonNull(dataConverter);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.cache = cache;
        this.contextPropagators = contextPropagators;
    }

    @Override
    public WorkflowImplementationOptions getWorkflowImplementationOptions() {
        return this.workflowImplementationOptions;
    }

    @Override
    public void start(HistoryEvent event, ReplayWorkflowContext context) {
        if (event.getEventType() != EventType.EVENT_TYPE_WORKFLOW_EXECUTION_STARTED || !event.hasWorkflowExecutionStartedEventAttributes()) {
            throw new IllegalArgumentException("first event is not WorkflowExecutionStarted, but " + event.getEventType());
        }
        WorkflowExecutionStartedEventAttributes startEvent = event.getWorkflowExecutionStartedEventAttributes();
        WorkflowType workflowType = startEvent.getWorkflowType();
        if (this.workflow == null) {
            throw new IllegalArgumentException("Unknown workflow type: " + workflowType);
        }
        Optional<Payloads> result = startEvent.hasLastCompletionResult() ? Optional.of(startEvent.getLastCompletionResult()) : Optional.empty();
        SyncWorkflowContext syncContext = new SyncWorkflowContext(context, this.dataConverter, this.contextPropagators, result);
        this.workflowProc = new WorkflowExecuteRunnable(syncContext, this.workflow, startEvent);
        this.runner = DeterministicRunner.newRunner(this.threadPool, syncContext, () -> {
            this.workflow.initialize();
            WorkflowInternal.newThread(false, "workflow-method", () -> this.workflowProc.run()).start();
        }, this.cache);
        this.runner.setInterceptorHead(syncContext.getWorkflowInterceptor());
    }

    @Override
    public void handleSignal(String signalName, Optional<Payloads> input, long eventId) {
        this.runner.executeInWorkflowThread("signal " + signalName, () -> this.workflowProc.processSignal(signalName, input, eventId));
    }

    @Override
    public boolean eventLoop() {
        if (this.runner == null) {
            return false;
        }
        this.runner.runUntilAllBlocked();
        return this.runner.isDone() || this.workflowProc.isDone();
    }

    @Override
    public Optional<Payloads> getOutput() {
        return this.workflowProc.getOutput();
    }

    @Override
    public void cancel(String reason) {
        this.runner.cancel(reason);
    }

    @Override
    public void close() {
        if (this.runner != null) {
            this.runner.close();
        }
    }

    @Override
    public Optional<Payloads> query(WorkflowQuery query) {
        if ("__replay_only".equals(query.getQueryType())) {
            return Optional.empty();
        }
        if ("__stack_trace".equals(query.getQueryType())) {
            return this.dataConverter.toPayloads(this.runner.stackTrace());
        }
        Optional<Payloads> args = query.hasQueryArgs() ? Optional.of(query.getQueryArgs()) : Optional.empty();
        return this.workflowProc.query(query.getQueryType(), args);
    }

    @Override
    public WorkflowExecutionException mapUnexpectedException(Throwable failure) {
        return POJOWorkflowImplementationFactory.mapToWorkflowExecutionException(failure, this.dataConverter);
    }
}

