/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import com.uber.m3.tally.Scope;
import io.temporal.activity.ActivityOptions;
import io.temporal.activity.LocalActivityOptions;
import io.temporal.api.command.v1.ContinueAsNewWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.ScheduleActivityTaskCommandAttributes;
import io.temporal.api.command.v1.SignalExternalWorkflowExecutionCommandAttributes;
import io.temporal.api.command.v1.StartChildWorkflowExecutionCommandAttributes;
import io.temporal.api.common.v1.ActivityType;
import io.temporal.api.common.v1.Header;
import io.temporal.api.common.v1.Memo;
import io.temporal.api.common.v1.Payload;
import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.RetryPolicy;
import io.temporal.api.common.v1.SearchAttributes;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.common.v1.WorkflowType;
import io.temporal.api.enums.v1.ParentClosePolicy;
import io.temporal.api.failure.v1.Failure;
import io.temporal.api.taskqueue.v1.TaskQueue;
import io.temporal.api.workflowservice.v1.PollActivityTaskQueueResponse;
import io.temporal.client.WorkflowException;
import io.temporal.common.RetryOptions;
import io.temporal.common.context.ContextPropagator;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.converter.DataConverterException;
import io.temporal.common.interceptors.WorkflowOutboundCallsInterceptor;
import io.temporal.failure.CanceledFailure;
import io.temporal.failure.ChildWorkflowFailure;
import io.temporal.failure.FailureConverter;
import io.temporal.failure.TemporalFailure;
import io.temporal.internal.common.HeaderUtils;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.common.OptionsUtils;
import io.temporal.internal.common.ProtobufTimeUtils;
import io.temporal.internal.replay.ChildWorkflowTaskFailedException;
import io.temporal.internal.replay.ExecuteActivityParameters;
import io.temporal.internal.replay.ExecuteLocalActivityParameters;
import io.temporal.internal.replay.ReplayWorkflowContext;
import io.temporal.internal.replay.StartChildWorkflowExecutionParameters;
import io.temporal.internal.sync.DeterministicRunner;
import io.temporal.internal.sync.WorkflowInternal;
import io.temporal.internal.sync.WorkflowRetryerInternal;
import io.temporal.internal.sync.WorkflowThread;
import io.temporal.workflow.CancellationScope;
import io.temporal.workflow.ChildWorkflowOptions;
import io.temporal.workflow.CompletablePromise;
import io.temporal.workflow.ContinueAsNewOptions;
import io.temporal.workflow.Functions;
import io.temporal.workflow.Promise;
import io.temporal.workflow.Workflow;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SyncWorkflowContext
implements WorkflowOutboundCallsInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SyncWorkflowContext.class);
    private final ReplayWorkflowContext context;
    private DeterministicRunner runner;
    private final DataConverter converter;
    private final List<ContextPropagator> contextPropagators;
    private WorkflowOutboundCallsInterceptor headInterceptor;
    private final Map<String, Functions.Func1<Optional<Payloads>, Optional<Payloads>>> queryCallbacks = new HashMap<String, Functions.Func1<Optional<Payloads>, Optional<Payloads>>>();
    private final Map<String, Functions.Proc2<Optional<Payloads>, Long>> signalCallbacks = new HashMap<String, Functions.Proc2<Optional<Payloads>, Long>>();
    private final Map<String, List<SignalData>> signalBuffers = new HashMap<String, List<SignalData>>();
    private final Optional<Payloads> lastCompletionResult;

    public SyncWorkflowContext(ReplayWorkflowContext context, DataConverter converter, List<ContextPropagator> contextPropagators, Optional<Payloads> lastCompletionResult) {
        this.context = context;
        this.converter = converter;
        this.contextPropagators = contextPropagators;
        this.lastCompletionResult = lastCompletionResult;
    }

    public void setRunner(DeterministicRunner runner) {
        this.runner = runner;
    }

    public DeterministicRunner getRunner() {
        return this.runner;
    }

    public WorkflowOutboundCallsInterceptor getWorkflowInterceptor() {
        return this.headInterceptor == null ? this : this.headInterceptor;
    }

    public void setHeadInterceptor(WorkflowOutboundCallsInterceptor head) {
        if (this.headInterceptor == null) {
            this.runner.setInterceptorHead(head);
            this.headInterceptor = head;
        }
    }

    public <T> Promise<T> executeActivity(String activityName, Class<T> returnClass, Type resultType, Object[] args, ActivityOptions options) {
        Optional<Payloads> input = this.converter.toPayloads(args);
        Promise<Optional<Payloads>> binaryResult = this.executeActivityOnce(activityName, options, input);
        if (returnClass == Void.TYPE) {
            return binaryResult.thenApply(r -> null);
        }
        return binaryResult.thenApply(r -> this.converter.fromPayloads(0, (Optional<Payloads>)r, returnClass, resultType));
    }

    private Promise<Optional<Payloads>> executeActivityOnce(String name, ActivityOptions options, Optional<Payloads> input) {
        ActivityCallback callback = new ActivityCallback();
        ExecuteActivityParameters params = this.constructExecuteActivityParameters(name, options, input);
        Functions.Proc1<Exception> cancellationCallback = this.context.scheduleActivityTask(params, callback::invoke);
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.apply(new CanceledFailure((String)reason));
            return null;
        });
        return callback.result;
    }

    @Override
    public <R> Promise<R> executeLocalActivity(String activityName, Class<R> resultClass, Type resultType, Object[] args, LocalActivityOptions options) {
        long startTime = WorkflowInternal.currentTimeMillis();
        return WorkflowRetryerInternal.retryAsync((attempt, currentStart) -> this.executeLocalActivityOnce(activityName, options, args, resultClass, resultType, currentStart - startTime, (int)attempt), 1, startTime);
    }

    private <T> Promise<T> executeLocalActivityOnce(String name, LocalActivityOptions options, Object[] args, Class<T> returnClass, Type returnType, long elapsed, int attempt) {
        Optional<Payloads> input = this.converter.toPayloads(args);
        Promise<Optional<Payloads>> binaryResult = this.executeLocalActivityOnce(name, options, input, attempt);
        if (returnClass == Void.TYPE) {
            return binaryResult.thenApply(r -> null);
        }
        return binaryResult.thenApply(r -> this.converter.fromPayloads(0, (Optional<Payloads>)r, returnClass, returnType));
    }

    private Promise<Optional<Payloads>> executeLocalActivityOnce(String name, LocalActivityOptions options, Optional<Payloads> input, int attempt) {
        ActivityCallback callback = new ActivityCallback();
        ExecuteLocalActivityParameters params = this.constructExecuteLocalActivityParameters(name, options, input, attempt);
        Functions.Proc cancellationCallback = this.context.scheduleLocalActivityTask(params, callback::invoke);
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.apply();
            return null;
        });
        return callback.result;
    }

    private ExecuteActivityParameters constructExecuteActivityParameters(String name, ActivityOptions options, Optional<Payloads> input) {
        Header header;
        List<ContextPropagator> propagators;
        RetryOptions retryOptions;
        String taskQueue = options.getTaskQueue();
        if (taskQueue == null) {
            taskQueue = this.context.getTaskQueue();
        }
        ScheduleActivityTaskCommandAttributes.Builder attributes = ScheduleActivityTaskCommandAttributes.newBuilder().setActivityType(ActivityType.newBuilder().setName(name)).setTaskQueue(TaskQueue.newBuilder().setName(taskQueue)).setScheduleToStartTimeout(ProtobufTimeUtils.toProtoDuration(options.getScheduleToStartTimeout())).setStartToCloseTimeout(ProtobufTimeUtils.toProtoDuration(options.getStartToCloseTimeout())).setScheduleToCloseTimeout(ProtobufTimeUtils.toProtoDuration(options.getScheduleToCloseTimeout())).setHeartbeatTimeout(ProtobufTimeUtils.toProtoDuration(options.getHeartbeatTimeout()));
        if (input.isPresent()) {
            attributes.setInput(input.get());
        }
        if ((retryOptions = options.getRetryOptions()) != null) {
            attributes.setRetryPolicy(SyncWorkflowContext.toRetryPolicy(retryOptions));
        }
        if ((propagators = options.getContextPropagators()) == null) {
            propagators = this.contextPropagators;
        }
        if ((header = HeaderUtils.toHeaderGrpc(this.extractContextsAndConvertToBytes(propagators))) != null) {
            attributes.setHeader(header);
        }
        return new ExecuteActivityParameters(attributes, options.getCancellationType());
    }

    static RetryPolicy.Builder toRetryPolicy(RetryOptions retryOptions) {
        RetryPolicy.Builder builder = RetryPolicy.newBuilder().setInitialInterval(ProtobufTimeUtils.toProtoDuration(retryOptions.getInitialInterval())).setMaximumInterval(ProtobufTimeUtils.toProtoDuration(retryOptions.getMaximumInterval())).setBackoffCoefficient(retryOptions.getBackoffCoefficient()).setMaximumAttempts(retryOptions.getMaximumAttempts());
        if (retryOptions.getDoNotRetry() != null) {
            builder = builder.addAllNonRetryableErrorTypes(Arrays.asList(retryOptions.getDoNotRetry()));
        }
        return builder;
    }

    private ExecuteLocalActivityParameters constructExecuteLocalActivityParameters(String name, LocalActivityOptions options, Optional<Payloads> input, int attempt) {
        options = LocalActivityOptions.newBuilder(options).validateAndBuildWithDefaults();
        PollActivityTaskQueueResponse.Builder activityTask = PollActivityTaskQueueResponse.newBuilder().setActivityId(this.context.randomUUID().toString()).setWorkflowNamespace(this.context.getNamespace()).setWorkflowExecution(this.context.getWorkflowExecution()).setScheduledTime(ProtobufTimeUtils.getCurrentProtoTime()).setStartToCloseTimeout(ProtobufTimeUtils.toProtoDuration(options.getStartToCloseTimeout())).setScheduleToCloseTimeout(ProtobufTimeUtils.toProtoDuration(options.getScheduleToCloseTimeout())).setStartedTime(ProtobufTimeUtils.getCurrentProtoTime()).setActivityType(ActivityType.newBuilder().setName(name)).setAttempt(attempt);
        if (input.isPresent()) {
            activityTask.setInput(input.get());
        }
        RetryOptions retryOptions = options.getRetryOptions();
        activityTask.setRetryPolicy(SyncWorkflowContext.toRetryPolicy(RetryOptions.newBuilder(retryOptions).validateBuildWithDefaults()));
        Duration localRetryThreshold = options.getLocalRetryThreshold();
        if (localRetryThreshold == null) {
            localRetryThreshold = this.context.getWorkflowTaskTimeout().multipliedBy(6L);
        }
        return new ExecuteLocalActivityParameters(activityTask, localRetryThreshold);
    }

    @Override
    public <R> WorkflowOutboundCallsInterceptor.WorkflowResult<R> executeChildWorkflow(String workflowType, Class<R> returnClass, Type returnType, Object[] args, ChildWorkflowOptions options) {
        Optional<Payloads> input = this.converter.toPayloads(args);
        CompletablePromise<WorkflowExecution> execution = Workflow.newPromise();
        Promise<Optional<Payloads>> output = this.executeChildWorkflow(workflowType, options, input, execution);
        Promise<Object> result = output.thenApply(b -> this.converter.fromPayloads(0, (Optional<Payloads>)b, returnClass, returnType));
        return new WorkflowOutboundCallsInterceptor.WorkflowResult<Object>(result, execution);
    }

    private Promise<Optional<Payloads>> executeChildWorkflow(String name, ChildWorkflowOptions options, Optional<Payloads> input, CompletablePromise<WorkflowExecution> executionResult) {
        ParentClosePolicy parentClosePolicy;
        RetryOptions retryOptions;
        CompletablePromise<Optional<Payloads>> result = Workflow.newPromise();
        if (CancellationScope.current().isCancelRequested()) {
            CanceledFailure CanceledFailure2 = new CanceledFailure("execute called from a canceled scope");
            executionResult.completeExceptionally(CanceledFailure2);
            result.completeExceptionally(CanceledFailure2);
            return result;
        }
        List<ContextPropagator> propagators = options.getContextPropagators();
        if (propagators == null) {
            propagators = this.contextPropagators;
        }
        StartChildWorkflowExecutionCommandAttributes.Builder attributes = StartChildWorkflowExecutionCommandAttributes.newBuilder().setWorkflowType(WorkflowType.newBuilder().setName(name).build());
        String workflowId = options.getWorkflowId();
        if (workflowId == null) {
            workflowId = this.randomUUID().toString();
        }
        attributes.setWorkflowId(workflowId);
        attributes.setNamespace(OptionsUtils.safeGet(options.getNamespace()));
        if (input.isPresent()) {
            attributes.setInput(input.get());
        }
        attributes.setWorkflowRunTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowRunTimeout()));
        attributes.setWorkflowExecutionTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowExecutionTimeout()));
        attributes.setWorkflowTaskTimeout(ProtobufTimeUtils.toProtoDuration(options.getWorkflowTaskTimeout()));
        String taskQueue = options.getTaskQueue();
        TaskQueue.Builder tl = TaskQueue.newBuilder();
        if (taskQueue != null) {
            attributes.setTaskQueue(TaskQueue.newBuilder().setName(taskQueue));
        }
        if (options.getWorkflowIdReusePolicy() != null) {
            attributes.setWorkflowIdReusePolicy(options.getWorkflowIdReusePolicy());
        }
        if ((retryOptions = options.getRetryOptions()) != null) {
            attributes.setRetryPolicy(SyncWorkflowContext.toRetryPolicy(retryOptions));
        }
        attributes.setCronSchedule(OptionsUtils.safeGet(options.getCronSchedule()));
        Header header = HeaderUtils.toHeaderGrpc(this.extractContextsAndConvertToBytes(propagators));
        if (header != null) {
            attributes.setHeader(header);
        }
        if ((parentClosePolicy = options.getParentClosePolicy()) != null) {
            attributes.setParentClosePolicy(parentClosePolicy);
        }
        StartChildWorkflowExecutionParameters parameters = new StartChildWorkflowExecutionParameters(attributes, options.getCancellationType());
        Functions.Proc1<Exception> cancellationCallback = this.context.startChildWorkflow(parameters, we -> this.runner.executeInWorkflowThread("child workflow started callback", () -> executionResult.complete((WorkflowExecution)we)), (output, failure) -> {
            if (failure != null) {
                this.runner.executeInWorkflowThread("child workflow failure callback", () -> result.completeExceptionally(this.mapChildWorkflowException((Exception)failure)));
            } else {
                this.runner.executeInWorkflowThread("child workflow completion callback", () -> result.complete((Optional<Payloads>)output));
            }
        });
        AtomicBoolean callbackCalled = new AtomicBoolean();
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            if (!callbackCalled.getAndSet(true)) {
                cancellationCallback.apply(new CanceledFailure((String)reason));
            }
            return null;
        });
        return result;
    }

    private Map<String, Payload> extractContextsAndConvertToBytes(List<ContextPropagator> contextPropagators) {
        if (contextPropagators == null) {
            return null;
        }
        HashMap<String, Payload> result = new HashMap<String, Payload>();
        for (ContextPropagator propagator : contextPropagators) {
            result.putAll(propagator.serializeContext(propagator.getCurrentContext()));
        }
        return result;
    }

    private RuntimeException mapChildWorkflowException(Exception failure) {
        if (failure == null) {
            return null;
        }
        if (failure instanceof TemporalFailure) {
            ((TemporalFailure)failure).setDataConverter(this.getDataConverter());
        }
        if (failure instanceof CanceledFailure) {
            return (CanceledFailure)failure;
        }
        if (failure instanceof WorkflowException) {
            return (RuntimeException)failure;
        }
        if (failure instanceof ChildWorkflowFailure) {
            return (ChildWorkflowFailure)failure;
        }
        if (!(failure instanceof ChildWorkflowTaskFailedException)) {
            return new IllegalArgumentException("Unexpected exception type: ", failure);
        }
        ChildWorkflowTaskFailedException taskFailed = (ChildWorkflowTaskFailedException)failure;
        Throwable cause = FailureConverter.failureToException(taskFailed.getFailure(), this.getDataConverter());
        if (cause == null) {
            cause = failure.getCause();
        }
        return new ChildWorkflowFailure(0L, 0L, taskFailed.getWorkflowType().getName(), taskFailed.getWorkflowExecution(), null, taskFailed.getRetryState(), cause);
    }

    @Override
    public Promise<Void> newTimer(Duration delay) {
        CompletablePromise<Void> p = Workflow.newPromise();
        Functions.Proc1<RuntimeException> cancellationHandler = this.context.newTimer(delay, e -> this.runner.executeInWorkflowThread("timer-callback", () -> {
            if (e == null) {
                p.complete(null);
            } else {
                p.completeExceptionally((RuntimeException)e);
            }
        }));
        CancellationScope.current().getCancellationRequest().thenApply(r -> {
            cancellationHandler.apply(new CanceledFailure((String)r));
            return r;
        });
        return p;
    }

    @Override
    public <R> R sideEffect(Class<R> resultClass, Type resultType, Functions.Func<R> func) {
        try {
            DataConverter dataConverter = this.getDataConverter();
            CompletablePromise result = Workflow.newPromise();
            this.context.sideEffect(() -> {
                Object r = func.apply();
                return dataConverter.toPayloads(r);
            }, p -> this.runner.executeInWorkflowThread("side-effect-callback", () -> result.complete(Objects.requireNonNull(p))));
            return dataConverter.fromPayloads(0, (Optional)result.get(), resultClass, resultType);
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public <R> R mutableSideEffect(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        try {
            return this.mutableSideEffectImpl(id, resultClass, resultType, updated, func);
        }
        catch (Error e) {
            throw e;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private <R> R mutableSideEffectImpl(String id, Class<R> resultClass, Type resultType, BiPredicate<R, R> updated, Functions.Func<R> func) {
        CompletablePromise result = Workflow.newPromise();
        AtomicReference unserializedResult = new AtomicReference();
        this.context.mutableSideEffect(id, storedBinary -> {
            Optional<Object> stored = storedBinary.map(b -> this.converter.fromPayloads(0, Optional.of(b), resultClass, resultType));
            Object funcResult = Objects.requireNonNull(func.apply(), "mutableSideEffect function returned null");
            if (!stored.isPresent() || updated.test(stored.get(), funcResult)) {
                unserializedResult.set(funcResult);
                return this.converter.toPayloads(funcResult);
            }
            return Optional.empty();
        }, p -> this.runner.executeInWorkflowThread("mutable-side-effect-callback", () -> result.complete(Objects.requireNonNull(p))));
        if (!((Optional)result.get()).isPresent()) {
            throw new IllegalArgumentException("No value found for mutableSideEffectId=" + id);
        }
        Object unserialized = unserializedResult.get();
        if (unserialized != null) {
            return (R)unserialized;
        }
        return this.converter.fromPayloads(0, (Optional)result.get(), resultClass, resultType);
    }

    @Override
    public int getVersion(String changeId, int minSupported, int maxSupported) {
        CompletablePromise result = Workflow.newPromise();
        this.context.getVersion(changeId, minSupported, maxSupported, v -> this.runner.executeInWorkflowThread("version-callback", () -> result.complete(v)));
        int r = (Integer)result.get();
        return r;
    }

    public Optional<Payloads> query(String type, Optional<Payloads> args) {
        Functions.Func1<Optional<Payloads>, Optional<Payloads>> callback = this.queryCallbacks.get(type);
        if (callback == null) {
            throw new IllegalArgumentException("Unknown query type: " + type + ", knownTypes=" + this.queryCallbacks.keySet());
        }
        return callback.apply(args);
    }

    public void signal(String signalName, Optional<Payloads> args, long eventId) {
        Functions.Proc2<Optional<Payloads>, Long> callback = this.signalCallbacks.get(signalName);
        if (callback == null) {
            List<SignalData> buffer = this.signalBuffers.get(signalName);
            if (buffer == null) {
                buffer = new ArrayList<SignalData>();
                this.signalBuffers.put(signalName, buffer);
            }
            buffer.add(new SignalData(args, eventId));
        } else {
            callback.apply(args, eventId);
        }
    }

    @Override
    public void registerQuery(String queryType, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Func1<Object[], Object> callback) {
        if (this.queryCallbacks.containsKey(queryType)) {
            throw new IllegalStateException("Query \"" + queryType + "\" is already registered");
        }
        this.queryCallbacks.put(queryType, input -> {
            Object[] args = DataConverter.arrayFromPayloads(this.converter, input, argTypes, genericArgTypes);
            Object result = callback.apply(args);
            return this.converter.toPayloads(result);
        });
    }

    @Override
    public void registerSignal(String signalType, Class<?>[] argTypes, Type[] genericArgTypes, Functions.Proc1<Object[]> callback) {
        if (this.signalCallbacks.containsKey(signalType)) {
            throw new IllegalStateException("Signal \"" + signalType + "\" is already registered");
        }
        Functions.Proc2<Optional, Long> signalCallback = (input, eventId) -> {
            try {
                Object[] args = DataConverter.arrayFromPayloads(this.converter, input, argTypes, genericArgTypes);
                callback.apply(args);
            }
            catch (DataConverterException e) {
                this.logSerializationException(signalType, (Long)eventId, e);
            }
        };
        List<SignalData> buffer = this.signalBuffers.remove(signalType);
        if (buffer != null) {
            for (SignalData signalData : buffer) {
                signalCallback.apply(signalData.getPayload(), signalData.getEventId());
            }
        }
        this.signalCallbacks.put(signalType, signalCallback);
    }

    void logSerializationException(String signalName, Long eventId, DataConverterException exception) {
        log.error("Failure deserializing signal input for \"" + signalName + "\" at eventId " + eventId + ". Dropping it.", (Throwable)exception);
        Workflow.getMetricsScope().counter("temporal_corrupted_signals").inc(1L);
    }

    @Override
    public UUID randomUUID() {
        return this.context.randomUUID();
    }

    @Override
    public Random newRandom() {
        return this.context.newRandom();
    }

    public DataConverter getDataConverter() {
        return this.converter;
    }

    boolean isReplaying() {
        return this.context.isReplaying();
    }

    public ReplayWorkflowContext getContext() {
        return this.context;
    }

    @Override
    public Promise<Void> signalExternalWorkflow(WorkflowExecution execution, String signalName, Object[] args) {
        SignalExternalWorkflowExecutionCommandAttributes.Builder attributes = SignalExternalWorkflowExecutionCommandAttributes.newBuilder();
        attributes.setSignalName(signalName);
        attributes.setExecution(execution);
        Optional<Payloads> input = this.getDataConverter().toPayloads(args);
        if (input.isPresent()) {
            attributes.setInput(input.get());
        }
        CompletablePromise<Void> result = Workflow.newPromise();
        Functions.Proc1<Exception> cancellationCallback = this.context.signalExternalWorkflowExecution(attributes, (output, failure) -> {
            if (failure != null) {
                this.runner.executeInWorkflowThread("child workflow failure callback", () -> result.completeExceptionally(FailureConverter.failureToException(failure, this.getDataConverter())));
            } else {
                this.runner.executeInWorkflowThread("child workflow completion callback", () -> result.complete((Void)output));
            }
        });
        CancellationScope.current().getCancellationRequest().thenApply(reason -> {
            cancellationCallback.apply(new CanceledFailure((String)reason));
            return null;
        });
        return result;
    }

    @Override
    public void sleep(Duration duration) {
        this.newTimer(duration).get();
    }

    @Override
    public boolean await(Duration timeout, String reason, Supplier<Boolean> unblockCondition) {
        Promise<Void> timer = this.newTimer(timeout);
        WorkflowThread.await(reason, () -> timer.isCompleted() || (Boolean)unblockCondition.get() != false);
        return !timer.isCompleted();
    }

    @Override
    public void await(String reason, Supplier<Boolean> unblockCondition) {
        WorkflowThread.await(reason, unblockCondition);
    }

    @Override
    public void continueAsNew(Optional<String> workflowType, Optional<ContinueAsNewOptions> options, Object[] args) {
        Optional<Payloads> payloads;
        ContinueAsNewWorkflowExecutionCommandAttributes.Builder attributes = ContinueAsNewWorkflowExecutionCommandAttributes.newBuilder();
        if (workflowType.isPresent()) {
            attributes.setWorkflowType(WorkflowType.newBuilder().setName(workflowType.get()));
        }
        if (options.isPresent()) {
            Map<String, Object> searchAttributes;
            Map<String, Object> memo;
            ContinueAsNewOptions ops = options.get();
            attributes.setWorkflowRunTimeout(ProtobufTimeUtils.toProtoDuration(ops.getWorkflowRunTimeout()));
            attributes.setWorkflowTaskTimeout(ProtobufTimeUtils.toProtoDuration(ops.getWorkflowTaskTimeout()));
            if (!ops.getTaskQueue().isEmpty()) {
                attributes.setTaskQueue(TaskQueue.newBuilder().setName(ops.getTaskQueue()));
            }
            if ((memo = ops.getMemo()) != null) {
                attributes.setMemo(Memo.newBuilder().putAllFields(HeaderUtils.convertMapFromObjectToBytes(memo, this.getDataConverter())));
            }
            if ((searchAttributes = ops.getSearchAttributes()) != null) {
                attributes.setSearchAttributes(SearchAttributes.newBuilder().putAllIndexedFields(HeaderUtils.convertMapFromObjectToBytes(searchAttributes, this.getDataConverter())));
            }
        }
        if ((payloads = this.getDataConverter().toPayloads(args)).isPresent()) {
            attributes.setInput(payloads.get());
        }
        this.context.continueAsNewOnCompletion(attributes.build());
        WorkflowThread.exit(null);
    }

    @Override
    public Promise<Void> cancelWorkflow(WorkflowExecution execution) {
        CompletablePromise<Void> result = Workflow.newPromise();
        this.context.requestCancelExternalWorkflowExecution(execution, (r, exception) -> {
            if (exception == null) {
                result.complete(null);
            } else {
                result.completeExceptionally((RuntimeException)exception);
            }
        });
        return result;
    }

    public Scope getMetricsScope() {
        return this.context.getMetricsScope();
    }

    public boolean isLoggingEnabledInReplay() {
        return this.context.getEnableLoggingInReplay();
    }

    public <R> R getLastCompletionResult(Class<R> resultClass, Type resultType) {
        DataConverter dataConverter = this.getDataConverter();
        return dataConverter.fromPayloads(0, this.lastCompletionResult, resultClass, resultType);
    }

    @Override
    public void upsertSearchAttributes(Map<String, Object> searchAttributes) {
        if (searchAttributes.isEmpty()) {
            throw new IllegalArgumentException("Empty search attributes");
        }
        SearchAttributes attr = InternalUtils.convertMapToSearchAttributes(searchAttributes, this.getDataConverter());
        this.context.upsertSearchAttributes(attr);
    }

    @Override
    public Object newThread(Runnable runnable, boolean detached, String name) {
        return this.runner.newThread(runnable, detached, name);
    }

    @Override
    public long currentTimeMillis() {
        return this.context.currentTimeMillis();
    }

    private class ActivityCallback {
        private final CompletablePromise<Optional<Payloads>> result = Workflow.newPromise();

        private ActivityCallback() {
        }

        public void invoke(Optional<Payloads> output, Failure failure) {
            if (failure != null) {
                SyncWorkflowContext.this.runner.executeInWorkflowThread("activity failure callback", () -> this.result.completeExceptionally(FailureConverter.failureToException(failure, SyncWorkflowContext.this.getDataConverter())));
            } else {
                SyncWorkflowContext.this.runner.executeInWorkflowThread("activity completion callback", () -> this.result.complete(output));
            }
        }
    }

    private static class SignalData {
        private final Optional<Payloads> payload;
        private final long eventId;

        private SignalData(Optional<Payloads> payload, long eventId) {
            this.payload = payload;
            this.eventId = eventId;
        }

        public Optional<Payloads> getPayload() {
            return this.payload;
        }

        public long getEventId() {
            return this.eventId;
        }
    }
}

