/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.activity;

import com.google.common.base.Objects;
import io.temporal.activity.ActivityCancellationType;
import io.temporal.common.MethodRetry;
import io.temporal.common.RetryOptions;
import io.temporal.common.context.ContextPropagator;
import java.time.Duration;
import java.util.List;

public final class ActivityOptions {
    private static final ActivityOptions DEFAULT_INSTANCE = ActivityOptions.newBuilder().build();
    private final Duration heartbeatTimeout;
    private final Duration scheduleToCloseTimeout;
    private final Duration scheduleToStartTimeout;
    private final Duration startToCloseTimeout;
    private final String taskQueue;
    private final RetryOptions retryOptions;
    private final List<ContextPropagator> contextPropagators;
    private final ActivityCancellationType cancellationType;

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(ActivityOptions options) {
        return new Builder(options);
    }

    public static ActivityOptions getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private ActivityOptions(Duration heartbeatTimeout, Duration scheduleToCloseTimeout, Duration scheduleToStartTimeout, Duration startToCloseTimeout, String taskQueue, RetryOptions retryOptions, List<ContextPropagator> contextPropagators, ActivityCancellationType cancellationType) {
        this.heartbeatTimeout = heartbeatTimeout;
        this.scheduleToCloseTimeout = scheduleToCloseTimeout;
        if (scheduleToCloseTimeout != null) {
            this.scheduleToStartTimeout = scheduleToStartTimeout == null ? scheduleToCloseTimeout : scheduleToStartTimeout;
            this.startToCloseTimeout = startToCloseTimeout == null ? scheduleToCloseTimeout : startToCloseTimeout;
        } else {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
            this.startToCloseTimeout = startToCloseTimeout;
        }
        this.taskQueue = taskQueue;
        this.retryOptions = retryOptions;
        this.contextPropagators = contextPropagators;
        this.cancellationType = cancellationType;
    }

    public Duration getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public Duration getScheduleToCloseTimeout() {
        return this.scheduleToCloseTimeout;
    }

    public Duration getScheduleToStartTimeout() {
        return this.scheduleToStartTimeout;
    }

    public Duration getStartToCloseTimeout() {
        return this.startToCloseTimeout;
    }

    public String getTaskQueue() {
        return this.taskQueue;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public List<ContextPropagator> getContextPropagators() {
        return this.contextPropagators;
    }

    public ActivityCancellationType getCancellationType() {
        return this.cancellationType;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActivityOptions that = (ActivityOptions)o;
        return this.cancellationType == that.cancellationType && Objects.equal((Object)this.heartbeatTimeout, (Object)that.heartbeatTimeout) && Objects.equal((Object)this.scheduleToCloseTimeout, (Object)that.scheduleToCloseTimeout) && Objects.equal((Object)this.scheduleToStartTimeout, (Object)that.scheduleToStartTimeout) && Objects.equal((Object)this.startToCloseTimeout, (Object)that.startToCloseTimeout) && Objects.equal((Object)this.taskQueue, (Object)that.taskQueue) && Objects.equal((Object)this.retryOptions, (Object)that.retryOptions) && Objects.equal(this.contextPropagators, that.contextPropagators);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.heartbeatTimeout, this.scheduleToCloseTimeout, this.scheduleToStartTimeout, this.startToCloseTimeout, this.taskQueue, this.retryOptions, this.contextPropagators, this.cancellationType});
    }

    public String toString() {
        return "ActivityOptions{heartbeatTimeout=" + this.heartbeatTimeout + ", scheduleToCloseTimeout=" + this.scheduleToCloseTimeout + ", scheduleToStartTimeout=" + this.scheduleToStartTimeout + ", startToCloseTimeout=" + this.startToCloseTimeout + ", taskQueue='" + this.taskQueue + '\'' + ", retryOptions=" + this.retryOptions + ", contextPropagators=" + this.contextPropagators + ", abandonOnCancellation=" + (Object)((Object)this.cancellationType) + '}';
    }

    public static final class Builder {
        private Duration heartbeatTimeout;
        private Duration scheduleToCloseTimeout;
        private Duration scheduleToStartTimeout;
        private Duration startToCloseTimeout;
        private String taskQueue;
        private RetryOptions retryOptions;
        private List<ContextPropagator> contextPropagators;
        private ActivityCancellationType cancellationType;

        private Builder() {
        }

        private Builder(ActivityOptions options) {
            if (options == null) {
                return;
            }
            this.taskQueue = options.taskQueue;
            this.heartbeatTimeout = options.heartbeatTimeout;
            this.retryOptions = options.retryOptions;
            this.contextPropagators = options.contextPropagators;
            this.scheduleToCloseTimeout = options.scheduleToCloseTimeout;
            this.startToCloseTimeout = options.startToCloseTimeout;
            this.scheduleToStartTimeout = options.scheduleToStartTimeout;
            this.cancellationType = options.cancellationType;
        }

        public Builder setScheduleToCloseTimeout(Duration scheduleToCloseTimeout) {
            this.scheduleToCloseTimeout = scheduleToCloseTimeout;
            return this;
        }

        public Builder setScheduleToStartTimeout(Duration scheduleToStartTimeout) {
            this.scheduleToStartTimeout = scheduleToStartTimeout;
            return this;
        }

        public Builder setStartToCloseTimeout(Duration startToCloseTimeout) {
            this.startToCloseTimeout = startToCloseTimeout;
            return this;
        }

        public Builder setHeartbeatTimeout(Duration heartbeatTimeoutSeconds) {
            this.heartbeatTimeout = heartbeatTimeoutSeconds;
            return this;
        }

        public Builder setTaskQueue(String taskQueue) {
            this.taskQueue = taskQueue;
            return this;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.retryOptions = retryOptions;
            return this;
        }

        public Builder setContextPropagators(List<ContextPropagator> contextPropagators) {
            this.contextPropagators = contextPropagators;
            return this;
        }

        public Builder setCancellationType(ActivityCancellationType cancellationType) {
            this.cancellationType = cancellationType;
            return this;
        }

        public Builder mergeMethodRetry(MethodRetry r) {
            this.retryOptions = RetryOptions.merge(r, this.retryOptions);
            return this;
        }

        public ActivityOptions build() {
            return new ActivityOptions(this.heartbeatTimeout, this.scheduleToCloseTimeout, this.scheduleToStartTimeout, this.startToCloseTimeout, this.taskQueue, this.retryOptions, this.contextPropagators, this.cancellationType);
        }

        public ActivityOptions validateAndBuildWithDefaults() {
            return new ActivityOptions(this.heartbeatTimeout, this.scheduleToCloseTimeout, this.scheduleToStartTimeout, this.startToCloseTimeout, this.taskQueue, this.retryOptions, this.contextPropagators, this.cancellationType == null ? ActivityCancellationType.TRY_CANCEL : this.cancellationType);
        }
    }
}

